package com.xunlei.niux.manager.web.task.apk;

import java.io.File;
import java.util.Calendar;
import com.xunlei.util.StringTools;


/**
 * 每天定时清理 没用的apk文件
 * @author lisu
 *  2014-09-04
 */
public class ApkClearTask {
	private static final String apkPath = "/usr/local/templatedata/apk/";
	private static final String customerPath = "/data/customer/";

	public static void main(String[] args) {
		System.out.println("customer log clear task  start ...");
		clearCustomerLog();
		System.out.println("customer log task  end ...");
		
		System.out.println("apk clear task  start ...");
		clearApk();
		System.out.println("apk clear task  end ...");
	}
	
	private static void clearCustomerLog(){
		try{
			  File file = new File(customerPath);
			  if(!file.exists()||!file.isDirectory())return;
			  Calendar cal = Calendar.getInstance();
			  if(cal.get(Calendar.DAY_OF_WEEK)==Calendar.WEDNESDAY){//如果是星期三
					File  childs [] = file.listFiles();
					if(childs == null||childs.length==0)return;
					for(File child:childs){
						child.delete();
					}
			  }		
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	private static void clearApk(){
		try{
			File file = new File(apkPath);
			if(!file.exists()||!file.isDirectory())return;
			File  childs [] = file.listFiles();
			if(childs == null||childs.length==0)return;
			for(File child:childs){
				File  apkchilds [] = child.listFiles();
				if(apkchilds == null||apkchilds.length==0)continue;
				for(File apkchild:apkchilds){
					String apkName = apkchild.getName();
					long lastModifyTime = apkchild.lastModified();
					long currentTime = System.currentTimeMillis();
					if(currentTime-lastModifyTime>1000*60*60*24*7){//大于7天的
						if(StringTools.isEmpty(apkName)
								||apkName.indexOf(".apk")==-1)continue;
                        if(apkName.length()>28){
                        	System.out.println(apkName+"  delete");
                        	apkchild.delete();
                        }else{
                        	if(apkName.indexOf("_000000")!=-1){
                        		System.out.println(apkName+"  delete");
                        		apkchild.delete();
                        	}                       	
                        }
					}
				}				
			}
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	

}
