package com.xunlei.niux.manager.web.task.agent;

import com.xunlei.niux.manager.web.task.AbstractBaseTask;
import com.xunlei.niux.manager.web.vo.ConnUtil;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;


public class AgentPayTask extends AbstractBaseTask {
	
	private static final DecimalFormat   fnum   =   new   DecimalFormat("##0.00");  

	
	public static void main(String[] args) {
		System.out.println("=======dayTask start=========="+".time:"+System.currentTimeMillis());
		dayTask();
		System.out.println("=======dayTask end=========="+".time:"+System.currentTimeMillis());
		if(isFirstDay()){
			System.out.println("=======monthTask start=========="+".time:"+System.currentTimeMillis());
			monthTask();
			System.out.println("=======monthTask end=========="+".time:"+System.currentTimeMillis());
		}
	}
	
	private static boolean isFirstDay(){
		Calendar c = Calendar.getInstance();
		int today = c.get(Calendar.DAY_OF_MONTH);
		if(today ==1){
			return true;
		}
		return false;
	}
	
	public static void dayTask(){
		System.out.println("=======deleteDay start=========");
		deleteDay("agentincome");
		System.out.println("=======payByDay start=========");
		payByDay();
		System.out.println("=======payByDay end=========");
		updateTestPayMoney();
		System.out.println("=======updateTestPayMoney end=========");
		System.out.println("=======deleteDay start=========");
		deleteDay("agenttestincome");
		testAccountPayByDay();
		System.out.println("=======testAccountPayByDay end=========");
	}

    /**
     * 每月一号更新上个月的agentmonthincome数据，计算分成收益
     */
	public static void monthTask(){
        String beforeDay = setDay(-1);
        String month = beforeDay.substring(0,7);
		monthTask(month);
	}

    /**
     * 更新指定月份的分成收益
     * @param month 格式:2015-01
     */
    public static void monthTask(String month){
        System.out.println("=======deleteMonth start=========");
        deleteMonth("agentmonthincome", month);
        deleteMonth("agenttestmonthincome", month);
        System.out.println("=======payByMonth start=========");
        payByMonth(month);
        System.out.println("=======testAccountPayByMonth start=========");
        testAccountPayByMonth(month);
        System.out.println("=======testAccountPayByMonth end=========");
        updateMonthDevelopPlatformMoney(month);
        System.out.println("=======updateMonthDevelopPlatformMoney end=========");
    }
	
	/**
	 *  测试账号日结
	 */
	public static void testAccountPayByDay(){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try{
			pconn = ConnUtil.getPayConn();
			conn = ConnUtil.getConn();
			String sql = "SELECT SUM(money) smoney ,s1.userid suserid ,s1.agentid sagentid,s1.gameid sgameid FROM agentpaydetail s1 inner JOIN agenttestaccount s2 ON s1.agentid=s2.agentid AND  s1.gameid=s2.gameid  AND s1.userid=s2.userid WHERE OrderIdStatus='S' AND SuccessTime>=? and SuccessTime<? GROUP BY s1.AgentId,s1.GameId,s1.userid;";
			pstmt = pconn.prepareStatement(sql);	
			String nowDay = nowDay();
			String beforeDay = setDay(-1);
			pstmt.setString(1,beforeDay+" 00:00:00");
			pstmt.setString(2,nowDay+" 00:00:00");
			rs = pstmt.executeQuery();
			String insertSql = "insert into agenttestincome values(null,?,?,?,?,?)";
			stmt = conn.prepareStatement(insertSql);
			while(rs.next()){
				String smoney = rs.getString("smoney");
				String agentid = rs.getString("sagentid");
				String gameid = rs.getString("sgameid");
				String userid = rs.getString("suserid");
				stmt.setString(1, agentid);
				stmt.setString(2, gameid);
				stmt.setString(3, beforeDay);
				stmt.setString(4, smoney);
				stmt.setString(5, userid);
				stmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	public static List<RemarkMoney> getRemarkMoney(){
		Connection pconn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		List<RemarkMoney> list = new ArrayList<RemarkMoney>();
		try{
			pconn = ConnUtil.getConn();
			String sql = "select * from agentremarkmoney where dayTime>=? and dayTime<=? order by inputBy asc";
			pstmt = pconn.prepareStatement(sql);	
			String beforeDay = setDay(-1);
			String month = beforeDay.substring(0,4);
			pstmt.setString(1, month+"-01");
			pstmt.setString(2, month+"-31");
			rs = pstmt.executeQuery();
			while(rs.next()){
				String agentId = rs.getString("platformNo");
				String gameId = rs.getString("gameId");
				String dayTime = rs.getString("dayTime");
				int operate = rs.getInt("operate");
				double money = rs.getDouble("money");
				RemarkMoney dto = new RemarkMoney();
				dto.setAgentId(agentId);
				dto.setGameId(gameId);
				dto.setDayTime(dayTime);
				dto.setMoney(money);
				dto.setIsAdd(operate==1?true:false);
				list.add(dto);
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return list;
	}
	
	public static List<AgentIntoSystemDTO> getAgentIntoSystem(){
		Connection pconn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		List<AgentIntoSystemDTO> list = new ArrayList<AgentIntoSystemDTO>();
		try{
			pconn = ConnUtil.getConn();
			String sql = "select * from agentintosystem order by gameId asc,agentId asc,beginmoney asc";
			pstmt = pconn.prepareStatement(sql);	
			rs = pstmt.executeQuery();
			while(rs.next()){
				String agentId = rs.getString("agentId");
				String gameId = rs.getString("gameId");
				int systemType = rs.getInt("systemType");
				int systype = rs.getInt("systype");
				int noregulartype = rs.getInt("noregulartype");
				int intoratio = rs.getInt("intoratio");
				long beginmoney = rs.getLong("beginmoney");
				long endmoney = rs.getLong("endmoney");
				AgentIntoSystemDTO dto = new AgentIntoSystemDTO();
				dto.setAgentId(agentId);
				dto.setGameId(gameId);
				dto.setSystemType(systemType);
				dto.setSystype(systype);
				dto.setNoregulartype(noregulartype);
				dto.setIntoratio(intoratio);
				dto.setBeginmoney(beginmoney);
				dto.setEndmoney(endmoney);
				list.add(dto);
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return list;
	}
	
	/**
	 *  独运充值日结
	 */
	public static void payByDay(){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try{
			pconn = ConnUtil.getPayConn();
			conn = ConnUtil.getConn();
			String sql = "SELECT SUM(money) smoney ,agentid,gameid FROM agentpaydetail where OrderIdStatus='S' and SuccessTime>=? and SuccessTime<? GROUP BY AgentId,GameId order by gameid asc,agentid asc";
			pstmt = pconn.prepareStatement(sql);	
			String nowDay = nowDay();
			String beforeDay = setDay(-1);
			pstmt.setString(1,beforeDay+" 00:00:00");
			pstmt.setString(2,nowDay+" 00:00:00");
			rs = pstmt.executeQuery();
			String insertSql = "insert into agentincome values(null,?,?,?,?,?,?)";
			stmt = conn.prepareStatement(insertSql);
			String zero = "0";
			Pair p;
			List<Pair> payList = new ArrayList<Pair>();
			while(rs.next()){
				String smoney = rs.getString("smoney");
				String agentid = rs.getString("agentid");
				String gameid = rs.getString("gameid");
				stmt.setString(1, agentid);
				stmt.setString(2, gameid);
				stmt.setString(3, beforeDay);
				stmt.setString(4, smoney);
				stmt.setString(5, zero);
				stmt.setString(6, smoney);
				
				//记录有充值的平台游戏
				p = new Pair(agentid, gameid);
				payList.add(p);
				
				stmt.execute();
				
			}
			
			//没有数据的平台游戏也创建记录
			sql = "SELECT platformNo as agentid,gameid FROM agentplatformgames where openStatus='3' GROUP BY AgentId,GameId";
			pstmt = conn.prepareStatement(sql);	
			rs = pstmt.executeQuery();
			conn.setAutoCommit(false);
			while(rs.next()){
				String smoney = zero;//rs.getString("smoney");
				String agentid = rs.getString("agentid");
				String gameid = rs.getString("gameid");
				
				//已经插了就不插入了
				boolean isExisted = false;
				for(Pair pair : payList){
					if(agentid.equals(pair.getKey()) && gameid.equals(pair.getValue())){
						isExisted = true;
						break;
					}
				}
				
				if(isExisted){
					continue;
				}
				
				stmt.setString(1, agentid);
				stmt.setString(2, gameid);
				stmt.setString(3, beforeDay);
				stmt.setString(4, smoney);
				stmt.setString(5, zero);
				stmt.setString(6, smoney);
				
				stmt.addBatch();
			}
			
			stmt.executeBatch();
	        conn.commit();
			
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	
	/**
	 * 获得研发方金额
	 * @return
	 */
	private static String getDevelpMoney( List<AgentIntoSystemDTO> develpList,double money){
		return getCalcMoney(develpList,money);
	}
	
	/**
	 * 获得接入平台金额
	 * @return
	 */
	private static String getPlatformMoney( List<AgentIntoSystemDTO> platformList,double money){
		return getCalcMoney(platformList,money);
	}
	
	private static  String getCalcMoney(List<AgentIntoSystemDTO> list,double money){
		if(CollectionUtils.isEmpty(list))return "0";
		AgentIntoSystemDTO dto = list.get(0);
		 BigDecimal bigMoney = new BigDecimal(money);
		int systype = dto.getSystype();
		if(systype==0){//如果是固定分成
			return  fnum.format((dto.getIntoratio()*money)/100);
		}else{//如果是非固定分成
			int noregulartype = dto.getNoregulartype();
		    if(noregulartype==0){//如果是区间值
		    	  Integer ratios = 0;
	                for(AgentIntoSystemDTO temp : list) {
	                    double beginMoney = temp.getBeginmoney() * 10000;
	                    double endMoney = temp.getEndmoney() != 0 ? temp.getEndmoney() * 10000 : Long.MAX_VALUE;
	                    double nowMoney = money;
	                    if(nowMoney > beginMoney && nowMoney<= endMoney) {
	                        ratios = temp.getIntoratio();
	                        break;
	                    }
	                }	               
	                return countByRadio(bigMoney, ratios);
		    }else{//如果是区间增量值
		    	  //区间增量
                return countByRadioAdd(list, bigMoney);
		    }
		}
	}
	
	 private static String countByRadioAdd(final List<AgentIntoSystemDTO> list, BigDecimal bigMoney) {
	        int num = 0;
	        for(AgentIntoSystemDTO temp : list) {
	            long beginMoney = temp.getBeginmoney() * 10000;
	            long endMoney = temp.getEndmoney() != 0 ? temp.getEndmoney() * 10000 : Long.MAX_VALUE;
	            long nowMoney =bigMoney.longValue();
	            if(nowMoney > beginMoney && nowMoney<= endMoney) {
	                break;
	            }
	            num++;
	        }
	        if(num>list.size()-1)return "0";
	        AgentIntoSystemDTO temp = list.get(num);
	        BigDecimal secondprincipal = (bigMoney.subtract(BigDecimal.valueOf(temp.getBeginmoney() * 10000)))
	                .multiply(BigDecimal.valueOf(temp.getIntoratio()))
	                .divide(BigDecimal.valueOf(100L));

	        if(num > 0) {
	            for(int i = num - 1; i >=0; i--) {
	            	AgentIntoSystemDTO is = list.get(i);
	                long beginMoney = is.getBeginmoney() * 10000;
	                long endMoney = is.getEndmoney() * 10000;
	                long value = (endMoney - beginMoney) * is.getIntoratio() / 100 ;
	                secondprincipal = secondprincipal.add(BigDecimal.valueOf(value));
	            }
	        }
	        return countFirstprincipal(bigMoney, secondprincipal);	        
	    }

	
	 private static String countByRadio(BigDecimal bigMoney, Integer ratios) {
	        BigDecimal secondprincipal = bigMoney.multiply(BigDecimal.valueOf(ratios))
	                .divide(BigDecimal.valueOf(100L));
	        return countFirstprincipal(bigMoney, secondprincipal);
	    }

	    private static String countFirstprincipal(BigDecimal bigMoney, BigDecimal secondprincipal) {
	        secondprincipal = secondprincipal.setScale(2, BigDecimal.ROUND_HALF_UP);
	        BigDecimal firstprincipal = bigMoney.subtract(secondprincipal);	        
	        return bigMoney.subtract(firstprincipal).toString();
	    }
	
	private static List<AgentIntoSystemDTO> findGameAgentIntoSystemDTO(String gameId,List<AgentIntoSystemDTO> platformList){
		 List<AgentIntoSystemDTO> newList = new ArrayList<AgentIntoSystemDTO>();
		for(AgentIntoSystemDTO dto:platformList){
			if(dto.getGameId().equals(gameId))
			    newList.add(dto);
		}
		return newList;
	}
	    
	/**
	 *  非固定分成时获得某游戏某平台的集合
	 * @param list
	 * @param agentId
	 * @param gameId
	 */
   private static Map<String,String> collectionDevelpAndPlatform(String money,List<AgentIntoSystemDTO> list,String agentId,String gameId){
	   List<AgentIntoSystemDTO> develpList = new ArrayList<AgentIntoSystemDTO>();
	   List<AgentIntoSystemDTO> platformList = new ArrayList<AgentIntoSystemDTO>();
	   calcDatas(develpList,platformList,list,agentId,gameId);
	   String platformMoney = getPlatformMoney(findGameAgentIntoSystemDTO(gameId,platformList),Double.parseDouble(money));
       //update by lizeyu on 2015-11-26 之前的计算方法错误，研发方分成，是要扣除平台方收益之后进行分成
	   String develpMoney = getDevelpMoney(findGameAgentIntoSystemDTO(gameId,develpList),Double.parseDouble(money)-Double.parseDouble(platformMoney));
	   Map<String,String> map = new HashMap<String,String>();
	   map.put("platformMoney", platformMoney);
	   map.put("develpMoney", develpMoney);
	   return map;
   }

   
   private static void calcDatas(List<AgentIntoSystemDTO> develpList,List<AgentIntoSystemDTO> platformList,List<AgentIntoSystemDTO> list,String agentId,String gameId){
	   for(AgentIntoSystemDTO dto:list){
		   if(dto.getAgentId().equals(agentId)&&dto.getGameId().equals(gameId)){
			   if(dto.getSystemType().intValue()==1){
				   develpList.add(dto);
			   }else{
				   platformList.add(dto);
			   }
		   }
	   }
   }
	
	/**
	 *   更新测试金额
	 */
	public static void updateTestPayMoney(){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try{
			pconn = ConnUtil.getPayConn();
			conn = ConnUtil.getConn();
			String sql = "SELECT SUM(money) smoney ,s1.agentid sagentid,s1.gameid sgameid FROM agentpaydetail s1 inner JOIN agenttestaccount s2 ON s1.agentid=s2.agentid AND  s1.gameid=s2.gameid  AND s1.userid=s2.userid WHERE OrderIdStatus='S' AND SuccessTime>=? and SuccessTime<? GROUP BY s1.AgentId,s1.GameId;";
			pstmt = pconn.prepareStatement(sql);	
			String nowDay = nowDay();
			String beforeDay = setDay(-1);
			pstmt.setString(1,beforeDay+" 00:00:00");
			pstmt.setString(2,nowDay+" 00:00:00");
			rs = pstmt.executeQuery();
			String insertSql = "update  agentincome set testMoney=?,realTotalMoney=totalMoney-testMoney where platformNo=? and gameId=? and dayTime=?";
			stmt = conn.prepareStatement(insertSql);
			while(rs.next()){
				String smoney = rs.getString("smoney");
				String agentid = rs.getString("sagentid");
				String gameid = rs.getString("sgameid");
				stmt.setString(1, smoney);
				stmt.setString(2, agentid);
				stmt.setString(3, gameid);
				stmt.setString(4, beforeDay);
				stmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	private static String getAfterRemarkRealMoney(List<RemarkMoney> remarkList,String agentId,String gameId,String money){
		long allMoney = 0L;
		for(RemarkMoney remark:remarkList){
			if(remark.getAgentId().equals(agentId)&&remark.getGameId().equals(gameId)){
				boolean isAdd = remark.getIsAdd();
				if(isAdd){
					allMoney +=remark.getMoney();					
				}else{
					allMoney -=remark.getMoney();
				}
			}
		}		
		return (Double.parseDouble(money)+allMoney)+"";
	}
	
//	/**
//	 *   更新研发方和接入平台金额
//	 */
//	public static void updateDayDevelopPlatformMoney(){
//		Connection pconn = null;
//		Connection conn = null;
//		PreparedStatement pstmt = null;
//		PreparedStatement stmt = null;
//		ResultSet rs = null;
//		try{
//			pconn = ConnUtil.getConn();
//			conn = ConnUtil.getConn();
//			String sql = "select platformNo,gameId,dayTime,realTotalMoney from agentincome where daytime=?";
//			pstmt = pconn.prepareStatement(sql);	
//			String beforeDay = setDay(-1);
//			pstmt.setString(1,beforeDay);
//			rs = pstmt.executeQuery();
//			String insertSql = "update  agentincome set developMoney=?,parterMoney=?,xunleiMoney=realTotalMoney-developMoney-parterMoney,realMoney=? where platformNo=? and gameId=? and dayTime=?";
//			stmt = conn.prepareStatement(insertSql);
//			List<AgentIntoSystemDTO> list = getAgentIntoSystem();
//			 List<RemarkMoney> remarkList = getRemarkMoney();
//			while(rs.next()){
//				String agentId = rs.getString("platformNo");
//				String gameId = rs.getString("gameId");
//				String dayTime = rs.getString("dayTime");
//				String realTotalMoney = rs.getString("realTotalMoney");				
//				Map<String,String> map = collectionDevelpAndPlatform(realTotalMoney,list,agentId,gameId);
//				String develpMoney =  map.get("develpMoney");
//				String platformMoney =  map.get("platformMoney");
//				stmt.setString(1, develpMoney);
//				stmt.setString(2, platformMoney);
//				double realMoney = Double.parseDouble(realTotalMoney)-Double.parseDouble(develpMoney)-Double.parseDouble(platformMoney);
//				stmt.setString(3, getAfterRemarkRealMoney(remarkList,agentId,dayTime,gameId,realMoney+""));//迅雷最终收益
//				stmt.setString(4, agentId);
//				stmt.setString(5, gameId);
//				stmt.setString(6, dayTime);
//				stmt.execute();
//			}
//		}catch(Exception e){
//			e.printStackTrace();
//		}finally{
//			try{
//				if(stmt != null){
//					stmt.close();
//					stmt = null;
//				}
//				if(conn != null){
//					conn.close();
//					conn = null;
//				}
//				if(rs != null){
//					rs.close();
//					rs = null;
//				}
//				if(pstmt != null){
//					pstmt.close();
//					pstmt = null;
//				}
//				if(pconn != null){
//					pconn.close();
//					pconn = null;
//				}				
//			}catch(Exception e){
//				e.printStackTrace();
//			}
//		}
//	}
	
	/**
	 *   更新月结研发方和接入平台金额
	 */
	public static void updateMonthDevelopPlatformMoney(String month){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try{
			pconn = ConnUtil.getConn();
			conn = ConnUtil.getConn();
			String sql = "select platformNo,gameId,month,realTotalMoney from agentmonthincome where month=?";
			pstmt = pconn.prepareStatement(sql);	
			pstmt.setString(1,month);
			rs = pstmt.executeQuery();
			String insertSql = "update  agentmonthincome set developMoney=?,parterMoney=?,xunleiMoney=realTotalMoney-developMoney-parterMoney,realMoney=? where platformNo=? and gameId=? and month=?";
			stmt = conn.prepareStatement(insertSql);
			List<AgentIntoSystemDTO> list = getAgentIntoSystem();
			 List<RemarkMoney> remarkList = getRemarkMoney();
			while(rs.next()){
				String agentId = rs.getString("platformNo");
				String gameId = rs.getString("gameId");
				String realTotalMoney = rs.getString("realTotalMoney");				
				Map<String,String> map = collectionDevelpAndPlatform(realTotalMoney,list,agentId,gameId);
				String develpMoney =  map.get("develpMoney");
				String platformMoney =  map.get("platformMoney");
				stmt.setString(1, develpMoney);
				stmt.setString(2, platformMoney);
				double realMoney = Double.parseDouble(realTotalMoney)-Double.parseDouble(develpMoney)-Double.parseDouble(platformMoney);
				stmt.setString(3, getAfterRemarkRealMoney(remarkList,agentId,gameId,realMoney+""));//迅雷最终收益
				stmt.setString(4, agentId);
				stmt.setString(5, gameId);
				stmt.setString(6, month);
				stmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}

    public static void deleteMonth(String tableName, String month){
        Connection pconn = null;
        PreparedStatement pstmt = null;
        try{
            pconn = ConnUtil.getConn();
            String sql = "delete from "+tableName+" where month=?";
            pstmt = pconn.prepareStatement(sql);
            pstmt.setString(1,month);
            pstmt.execute();
        }catch(Exception e){
            e.printStackTrace();
        }finally{
            try{
                if(pstmt != null){
                    pstmt.close();
                    pstmt = null;
                }
                if(pconn != null){
                    pconn.close();
                    pconn = null;
                }
            }catch(Exception e){
                e.printStackTrace();
            }
        }

    }
	
	public static void deleteDay(String tableName){
		Connection pconn = null;
		PreparedStatement pstmt = null;
		try{
			pconn = ConnUtil.getConn();
			String sql = "delete from "+tableName+" where daytime=?";
			pstmt = pconn.prepareStatement(sql);	
			String beforeDay = setDay(-1);
			pstmt.setString(1,beforeDay);
			pstmt.execute();
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
   private static String getMonth(){
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.MONTH, -1);
		SimpleDateFormat tempsdf = new SimpleDateFormat("yyyy-MM-dd");
		 return  tempsdf.format(cal.getTime());// 当前时间的前一天		 
   }
	
	/**
	 *  独运充值月结
	 */
	public static void payByMonth(String month){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try{
			pconn = ConnUtil.getConn();
			conn = ConnUtil.getConn();
			String sql = "SELECT platformNo,gameid,SUM(totalMoney) stotalMoney,SUM(testMoney) stestMoney, SUM(realTotalMoney) srealTotalMoney FROM agentincome WHERE dayTime>=? AND daytime<=? GROUP BY platformNo,gameid;";
			pstmt = pconn.prepareStatement(sql);	
			pstmt.setString(1,month+"-01 00:00:00");
			pstmt.setString(2,month+"-31 23:59:59");
			rs = pstmt.executeQuery();
			String insertSql = "insert into agentmonthincome values(null,?,?,?,?,?,?,?,?,?,?)";
			String zero = "0";
			Pair p;
			List<Pair> payList = new ArrayList<Pair>();
			stmt = conn.prepareStatement(insertSql);
			while(rs.next()){
				String platformNo = rs.getString("platformNo");
				String gameid = rs.getString("gameid");
				String stotalMoney = rs.getString("stotalMoney");
				String stestMoney = rs.getString("stestMoney");
				String srealTotalMoney = rs.getString("srealTotalMoney");
				stmt.setString(1, platformNo);
				stmt.setString(2, gameid);
				stmt.setString(3, month);
				stmt.setString(4, stotalMoney);
				stmt.setString(5, stestMoney);
				stmt.setString(6, srealTotalMoney);
				stmt.setString(7, zero);
				stmt.setString(8, zero);
				stmt.setString(9, zero);
				stmt.setString(10, zero);
				
				//记录有充值的平台游戏
				p = new Pair(platformNo, gameid);
				payList.add(p);
				
				stmt.execute();
			}

			//没有数据的平台游戏也创建记录
			sql = "SELECT platformNo,gameid FROM agentplatformgames where openStatus='3' GROUP BY platformNo,gameid";
			pstmt = conn.prepareStatement(sql);	
			rs = pstmt.executeQuery();
			conn.setAutoCommit(false);
			while(rs.next()){
				String platformNo = rs.getString("platformNo");
				String gameid = rs.getString("gameid");
				String stotalMoney = zero;//rs.getString("stotalMoney");
				String stestMoney = zero;//rs.getString("stestMoney");
				String srealTotalMoney = zero;//rs.getString("srealTotalMoney");
				
				//已经插了就不插入了
				boolean isExisted = false;
				for(Pair pair : payList){
					if(platformNo.equals(pair.getKey()) && gameid.equals(pair.getValue())){
						isExisted = true;
						break;
					}
				}
				
				if(isExisted){
					continue;
				}

				stmt.setString(1, platformNo);
				stmt.setString(2, gameid);
				stmt.setString(3, month);
				stmt.setString(4, stotalMoney);
				stmt.setString(5, stestMoney);
				stmt.setString(6, srealTotalMoney);
				stmt.setString(7, zero);
				stmt.setString(8, zero);
				stmt.setString(9, zero);
				stmt.setString(10, zero);
				
				stmt.addBatch();
			}
			
			stmt.executeBatch();
	        conn.commit();
			
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}

	/**
	 *  测试账号月结
	 */
	public static void testAccountPayByMonth(String month){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try{
			pconn = ConnUtil.getConn();
			conn = ConnUtil.getConn();
			String sql = "SELECT agentId,gameid ,account,SUM(money) smoney FROM agenttestincome WHERE dayTime>=? AND daytime<=? GROUP BY agentId,gameid,account;";
			pstmt = pconn.prepareStatement(sql);	
			pstmt.setString(1,month+"-01 00:00:00");
			pstmt.setString(2,month+"-31 23:59:59");
			rs = pstmt.executeQuery();
			String insertSql = "insert into agenttestmonthincome values(null,?,?,?,?,?)";
			stmt = conn.prepareStatement(insertSql);
			while(rs.next()){
				String agentId = rs.getString("agentId");
				String gameid = rs.getString("gameid");
				String smoney = rs.getString("smoney");
				String userid = rs.getString("account");
				stmt.setString(1, agentId);
				stmt.setString(2, gameid);
				stmt.setString(3, month);
				stmt.setString(4, smoney);
				stmt.setString(5, userid);
				stmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}

}
