package com.xunlei.niux.manager.web.task.agent;

import com.xunlei.niux.manager.web.task.AbstractBaseTask;
import com.xunlei.niux.manager.web.vo.ConnUtil;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;


public class AgentPayGameid000001 extends AbstractBaseTask {
	
	private static final DecimalFormat   fnum   =   new   DecimalFormat("##0.00");
    private static final SimpleDateFormat dateFormat = new java.text.SimpleDateFormat("yyyy-MM-dd");


	public static void main(String[] args) {

//        ("update agentpaydetail set gameid = '000003', gameext = '000001' where agentid='xunlei' and gameid = '000001';");
        exeManagerSql("delete from agentincome where platformno='xunlei' and gameid='000003';");
        payByDay();
        exeManagerSql("delete from agentmonthincome where platformno='xunlei' and gameid='000003';");
        payByMonth();

    }


	/**
	 *  独运充值日结
	 */
	public static void payByDay(){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try{
			pconn = ConnUtil.getPayConn();
			conn = ConnUtil.getConn();
			String sql = "select agentid as platformNo, gameId, date_format(successTime,'%Y-%m-%d') as dayTime, SUM(money) as totalMoney, 0 as testMoney, SUM(money) as realTotalMoney\n" +
                    "FROM agentpaydetail where OrderIdStatus='S' and agentid ='xunlei' and gameid='000003' GROUP BY dayTime order by dayTime";
			pstmt = pconn.prepareStatement(sql);	
			rs = pstmt.executeQuery();
			String insertSql = "insert into agentincome(platformNo, gameId, dayTime,totalMoney,testMoney,realTotalMoney) values(?,?,?,?,?,?)";
			stmt = conn.prepareStatement(insertSql);
			while(rs.next()){
				stmt.setString(1, rs.getString("platformNo"));
				stmt.setString(2, rs.getString("gameId"));
				stmt.setString(3, rs.getString("dayTime"));
				stmt.setString(4, rs.getString("totalMoney"));
				stmt.setString(5, rs.getString("testMoney"));
				stmt.setString(6, rs.getString("realTotalMoney"));
				stmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}


	private static void exeManagerSql(String sql){
		Connection pconn = null;
		PreparedStatement pstmt = null;
		try{
			pconn = ConnUtil.getConn();
			pstmt = pconn.prepareStatement(sql);
			pstmt.execute();
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}


	/**
	 *  独运充值月结
	 */
	public static void payByMonth(){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try{
			pconn = ConnUtil.getConn();
			conn = ConnUtil.getConn();
			String sql = "select platformNo, gameId, date_format(dayTime,'%Y-%m') as month, sum(totalMoney) as totalMoney,sum(testMoney) as testMoney , sum(realtotalMoney) as realtotalMoney,\n" +
                    "sum(realtotalMoney) as xunleiMoney, 0 as parterMoney, 0 as developMoney,  sum(realtotalMoney) as realMoney\n" +
                    "from agentincome where platformNo = 'xunlei' and gameId ='000003' group by month ORDER BY month ";
			pstmt = pconn.prepareStatement(sql);	
			rs = pstmt.executeQuery();
			String insertSql = "insert into agentmonthincome(platformNo, gameId, month,totalMoney,testMoney,realTotalMoney, \n" +
                    "xunleiMoney, parterMoney, developMoney, realMoney) values(?,?,?,?,?,?,?,?,?,?)";
			String zero = "0";
			stmt = conn.prepareStatement(insertSql);
			while(rs.next()){
                stmt.setString(1, rs.getString("platformNo"));
                stmt.setString(2, rs.getString("gameId"));
                stmt.setString(3, rs.getString("month"));
                stmt.setString(4, rs.getString("totalMoney"));
                stmt.setString(5, rs.getString("testMoney"));
                stmt.setString(6, rs.getString("realTotalMoney"));
                stmt.setString(7, rs.getString("xunleiMoney"));
                stmt.setString(8, rs.getString("parterMoney"));
                stmt.setString(9, rs.getString("developMoney"));
                stmt.setString(10, rs.getString("realMoney"));
				stmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
}
