package com.xunlei.niux.manager.web.task.agent;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import com.xunlei.niux.manager.web.vo.ConnUtil;

/**
 * 补录独运历史数据
 * @author lisu
 * 2015-02-05
 */
public class AgentHistoryTask {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		System.out.println("========addDayHistory start =========");
		addDayHistory();
		System.out.println("========addDayHistory end =========");
		addMonthHistory();
		System.out.println("========addMonthHistory end =========");
	}

	
	public static void addDayHistory(){
		Connection conn = null;
		Connection iconn = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try{
			conn = ConnUtil.getPayConn();
			iconn = ConnUtil.getConn();
			stmt = conn.createStatement();
			String sql = "select * from chargedayend where gameid='00180' and  balancedate<='2015-01-16' order by balancedate asc";
			String insertSql = "insert into agentincome values(null,'xunlei','000001',?,?,?,?)";
			rs = stmt.executeQuery(sql);
			pstmt = iconn.prepareStatement(insertSql);
			while(rs.next()){
				pstmt.setString(1, rs.getString("balancedate"));
				pstmt.setDouble(2, rs.getDouble("allamt"));
				pstmt.setDouble(3, rs.getDouble("testamt"));
				pstmt.setDouble(4, rs.getDouble("allamt")-rs.getDouble("testamt"));
				pstmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(iconn != null){
					iconn.close();
					iconn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	
	public static void addMonthHistory(){
		Connection conn = null;
		Connection iconn = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try{
			conn = ConnUtil.getPayConn();
			iconn = ConnUtil.getConn();
			stmt = conn.createStatement();
			String sql = "select * from chargemonthend where gameid='00180' and balancemonth<'2015-01' order by balancemonth asc";
			String insertSql = "insert into agentmonthincome values(null,'xunlei','000001',?,?,?,?,?,'0','0',?)";
			rs = stmt.executeQuery(sql);
			pstmt = iconn.prepareStatement(insertSql);
			while(rs.next()){
				pstmt.setString(1, rs.getString("balancemonth"));
				pstmt.setDouble(2, rs.getDouble("allamt"));
				pstmt.setDouble(3, rs.getDouble("testamt"));
				pstmt.setDouble(4, rs.getDouble("allamt")-rs.getDouble("testamt"));
				pstmt.setDouble(5, rs.getDouble("allamt")-rs.getDouble("testamt"));
				pstmt.setDouble(6, rs.getDouble("allamt")-rs.getDouble("testamt"));
				pstmt.execute();
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(iconn != null){
					iconn.close();
					iconn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}
