package com.xunlei.niux.manager.web.task.act;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xunlei.common.util.StringTools;
import com.xunlei.niux.manager.web.task.AbstractBaseTask;
import com.xunlei.niux.manager.web.vo.ConnUtil;

public class ActivityTask extends AbstractBaseTask{
	
	private static final int FIRSTDAY = -1;
	private static final int SECORDDAY = -7;
	private static final int THREEDAY = -8;
	//private static final String ALLRECEIVER = "xlnxdps@xunlei.com";
	private static  String ALLRECEIVER = "lisu@xunlei.com";
			
	public static void main(String[] args) {
		if(args != null){
			ALLRECEIVER = args[0];
			sendMail();
		}
	
	}
	
	public static void sendMail(){
		Map<String,String> map = getContantNumberMap(10,1);
		System.out.println("map:"+map);
		//活动结束第一天邮件
		System.out.println("======ActivityTask===== sendFirstMail=====");
		sendFirstMail(FIRSTDAY,map);
		//活动结束第七天邮件
		System.out.println("======ActivityTask===== sendSecordMail=====");
		sendSecordMail(SECORDDAY,map);
		//活动结束第八天全员邮件
		System.out.println("======ActivityTask===== sendThreeMail=====");
		sendThreeMail(THREEDAY,map);
	}
	
	
	private static List<ActivityDTO> getActivitys(int days){
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		List<ActivityDTO> adtoList = new ArrayList<ActivityDTO>();
		try{
			conn = ConnUtil.getActConn();
			String sql = "select * from activity_activity where checkStatus=1 and endtime>=? and endtime<?";
			stmt = conn.prepareStatement(sql);	
			String nowDay = setDay(days+1);
			String beforeDay = setDay(days);
			stmt.setString(1,beforeDay+" 00:00:00");
			stmt.setString(2,nowDay+" 00:00:00");
			rs = stmt.executeQuery();
			while(rs.next()){
				String actNo = rs.getString("actNo");
				String title = rs.getString("title");
				String endTime = rs.getString("endTime");
				String manager = rs.getString("manager");
				String link = rs.getString("link");
				ActivityDTO dto = new ActivityDTO();
				dto.setActNo(actNo);
				dto.setTitle(title);
				dto.setEndTime(endTime);
				dto.setManager(manager);
				dto.setLink(link);
				adtoList.add(dto);
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(rs != null){
					rs.close();
					rs = null;
				}
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return adtoList;
	}
	
	private static int getStep(int days){
		switch(days){
		   case FIRSTDAY:return 1;
		   case SECORDDAY:return 2;
		   case THREEDAY:return 3;		   
		}
		return 0;
	}
	
	private static void sendFirstMail(int days,Map<String,String> map){
		int step = getStep(days);
		List<ActivityDTO> adtoList = getActivitys(days);		
		for(ActivityDTO adto:adtoList){
			String content = getContent(step,adto);		
			String manager = adto.getManager();
			if(StringTools.isEmpty(manager))continue;
			String receiver = map.get(manager.trim());
			if(StringTools.isEmpty(receiver))continue;
			sendMail("提醒：活动总结提交——"+adto.getTitle()+"活动",content,receiver);
		}
	}
	
	private static String getFormatDay(String endTime){
		String times [] = endTime.split(" ");
		String nowDay = setSettingDay(times[0],-THREEDAY);
		String params [] = nowDay.split("-");
		StringBuilder sb = new StringBuilder();
		sb.append(params[0]).append("年").append(params[1]).append("月").append(params[2]).append("日");
		return sb.toString();
	}
	
	private static String getContent(int step,ActivityDTO adto){
		StringBuilder builder = new StringBuilder();	
	    if(step<=2){			
	    	builder.append("亲爱的").append(adto.getManager()).append(":<br/>")
			.append("&nbsp;&nbsp;您所负责的活动\"").append(adto.getTitle()).append("\"，")
			.append("活动时间已经结束");
	    	if(step ==2){
	    		builder.append(-SECORDDAY).append("天");
	    	}			
			builder.append("，请尽快在")
			.append(getFormatDay(adto.getEndTime()))
			.append("24点之前，在迅雷牛X平台后台管理系统—>活动管理—>活动维护中填写活动总结。");
		}else if(step==3){		
			builder.append("活动——“"+adto.getTitle()+"”活动总结还未提交，")
			.append("<br/>").append("活动链接：").append(adto.getLink()).append("<br/>")
			.append("负责人：").append(adto.getManager()).append("<br/>").append("活动结束时间：")
			.append(adto.getEndTime()).append("<br/>").append("请活动负责人尽快提交活动总结！");
		}
	    builder.append("<br/>")
		.append(nowDay());
		return builder.toString();
	}
	
	
	
	
	private static void sendSecordMail(int days,Map<String,String> map){
		int step = getStep(days);
		List<ActivityDTO> adtoList = getActivitys(days);
		for(ActivityDTO adto:adtoList){
			String content = getContent(step,adto);
			String manager = adto.getManager();
			if(StringTools.isEmpty(manager))continue;
			System.out.println("manager:"+manager);
			String receiver = map.get(manager.trim());
			System.out.println("receiver:"+receiver);
			if(StringTools.isEmpty(receiver))continue;
			sendMail("再次提醒：活动总结提交——"+adto.getTitle()+"活动",content,receiver);
		}
	}
	
	private static void sendThreeMail(int days,Map<String,String> map){
		int step = getStep(days);
		List<ActivityDTO> adtoList = getActivitys(days);
		for(ActivityDTO adto:adtoList){
			String manager = adto.getManager();
			String receiver = map.get(manager.trim());
			if(StringTools.isEmpty(receiver))continue;
			String content = getContent(step,adto);
			System.out.println("ALLRECEIVER:"+ALLRECEIVER);
			sendMail("活动总结未提交——"+adto.getTitle()+"活动",content,ALLRECEIVER);
		}
	}
}
