package com.xunlei.niux.manager.web.task;

import com.xunlei.niux.manager.web.vo.ConnUtil;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;


public class DuiZhang {

	private static final DecimalFormat   fnum   =   new   DecimalFormat("##0.00");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    private static final String SQL_GAME_PAY = "select sum(TotalMoney) as totalMoney,gameid from paydetailok where OrderIdStatus='S' and PayCode='00' and gameid like '0%' " +
            " and  SuccessTime >=? and  SuccessTime < ? and ToInnerUserid not in ('292604999', '123540516') group by gameid order by gameid desc";

    private static final String SQL_GAME_INFO = "select distinct d.gamename,c.gameid from  gameservers c,games d " +
            " where  c.openstatus ='1' and c.gameid like '00%' and c.gameid=d.gameid order by gameid desc ";

	public static void main(String[] args) {
        if(args==null||args.length!=2){
            System.out.println("Please input start data and end date, like 2015-04-01 2015-04-30");
        }
        String a1 = args[0];
        String a2 = args[1];

        if(a1==null||a2==null){
            System.out.println("Not found the data argument");
        }
        System.out.println("arg0="+args[0]);
        System.out.println("arg1="+args[1]);

        go(a1,a2);
    }


	public static void go(String startDate, String endDate){
		Connection pconn = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		ResultSet rs2 = null;
		try{

			pconn = ConnUtil.getPayConn();
            pstmt = pconn.prepareStatement(SQL_GAME_PAY);
            pstmt.setString(1,startDate+" 00:00:00");
            pstmt.setString(2,endDate+" 24");
            rs = pstmt.executeQuery();
            Map<String,BigDecimal> pmap = new HashMap<String,BigDecimal>();
            while(rs.next()){
                pmap.put("0"+rs.getString("gameid"),rs.getBigDecimal("totalMoney"));
            }

            conn = ConnUtil.getConn();
            stmt = conn.prepareStatement(SQL_GAME_INFO);
            rs2 = stmt.executeQuery();
            while(rs2.next()){
                System.out.println(rs2.getString("gamename")+","+rs2.getString("gameid")+","+pmap.get(rs2.getString("gameid")));
            }

		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try{
				if(stmt != null){
					stmt.close();
					stmt = null;
				}
				if(conn != null){
					conn.close();
					conn = null;
				}
				if(rs != null){
					rs.close();
					rs = null;
				}if(rs2 != null){
					rs2.close();
					rs2 = null;
				}
				if(pstmt != null){
					pstmt.close();
					pstmt = null;
				}
				if(pconn != null){
					pconn.close();
					pconn = null;
				}				
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}


}
