package com.xunlei.niux.manager.web.task;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.xunlei.niux.manager.web.exception.NiuxException;
import com.xunlei.niux.manager.web.util.EmailSender;
import com.xunlei.niux.manager.web.util.SmsClient;
import com.xunlei.niux.manager.web.vo.ConnUtil;
import com.xunlei.util.StringTools;

public  class AbstractBaseTask {
	private static final Logger logger = Logger.getLogger(AbstractBaseTask.class.getName());	
	protected static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static final int minHour = 8;
	private static final int maxHour = 20;
	
	protected static void addLog(String message,String action){
 	   logger.info("nowtime:"+nowTime()+",action:"+action+",message"+message);
    }
    
	/**
	 * 判断当前时间是否白天
	 * @return
	 */
	protected static boolean isDay(){
		Calendar cal = Calendar.getInstance();
		int hour=cal.get(Calendar.HOUR_OF_DAY);//得到小时
		System.out.println("hour:"+hour);
		return hour>=minHour && hour<=maxHour;
	}
	
	/**
	 * 获得当前时间
	 * @return
	 */
	protected static String nowTime(){
		return sdf.format(new Date());
	}
	
	/**
	 * 获得当前日期
	 * @return
	 */
	protected static String nowDay(){
		return sdf.format(new Date()).split(" ")[0];
	}
	
	
	/**
	 * 指定天数之前或之后，负数表示之前，正数表示之后
	 * @param days
	 * @return
	 */
	protected static String setDay(int days){
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, days);
		SimpleDateFormat tempsdf = new SimpleDateFormat("yyyy-MM-dd");
		 return  tempsdf.format(cal.getTime());// 当前时间的前一天
	}
	
	protected static String setSettingDay(String dayTime,int days){
		SimpleDateFormat tempsdf = new SimpleDateFormat("yyyy-MM-dd");
		try {
			Date date = tempsdf.parse(dayTime);
			Calendar cal = Calendar.getInstance();
			cal.setTime(date);
			cal.add(Calendar.DAY_OF_MONTH, days);
			return tempsdf.format(cal.getTime());
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	/***
	 *  获取当前时间前一天日期
	 * @return
	 */
	protected static String beforeDay(){
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, -1);
		SimpleDateFormat tempsdf = new SimpleDateFormat("yyyy-MM-dd");
		 return  tempsdf.format(cal.getTime());// 当前时间的前一天
	}
	
	protected static boolean compareTime(String time1,String time2){
		if(StringTools.isEmpty(time1))return false;
		if(StringTools.isEmpty(time2))return true;
		SimpleDateFormat tempsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try {
			Date date1 = tempsdf.parse(time1);
			Date date2 = tempsdf.parse(time2);
			return date1.getTime()-date2.getTime()>=0?true:false;
		} catch (ParseException e) {
			return false;
		}
	}
	
	/**
	 * 同步文件
	 * @param fileName
	 */
	protected static void synch(String fileName){
   		try {
   			Runtime.getRuntime().exec("/usr/local/bin/"+fileName);	
   		} catch (IOException e) {
   			logger.error("synch io error ", e);
   		}catch(Exception e1){
   			logger.error("synch error", e1);
   		}
   	}
	
	/**
	 * 发送邮件
	 * @param title
	 * @param content
	 * @param receivers
	 */
	protected static void sendMail(String title,String content,String ... receivers){
		 try {
			EmailSender.sendMail(title, content, receivers);
		} catch (Exception e) {
			logger.error("sendMail error", e);
		}
	}
	
	/**
	 * 发送短信
	 * @param content
	 * @param receivers
	 */
	protected static void sendSms(String content,String ...receivers){
		for(String receiver:receivers){
			try {
				SmsClient.sendSms(receiver, content);
			} catch (NiuxException e) {
				 logger.error("sendSms error:",e);
			}
		}		
	}
	
	/**
	 * 返回手机号 + 邮箱
	 * @param type
	 * @param num 1：邮箱 2：手机号 3：邮箱+手机号
	 * @return
	 */
	protected static List<String> getContantNumber(int type,int num){
		   Connection conn = null;
		   PreparedStatement pstmt = null;
		   ResultSet rs = null;
		   List<String> numberList = new ArrayList<String>();
		   try{
			   conn = ConnUtil.getConn();
			   String sql = "select * from interfaceman where type=?";
			   pstmt = conn.prepareStatement(sql);
			   pstmt.setInt(1, type);
			   rs = pstmt.executeQuery();			
			   while(rs.next()){
				   String interfacePhone = rs.getString("interfacePhone").trim();
				   String interfaceEmail = rs.getString("interfaceEmail").trim();
				   switch(num){
				   case 1:				
					   numberList.add(interfaceEmail);
				   case 2:
					   numberList.add(interfacePhone);
				   case 3:
					   numberList.add(interfacePhone+"_"+interfaceEmail);
				   }				 
			   }
		   }catch(Exception e){
			   logger.error("getContantNumber error:",e);
		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(pstmt != null){
					   pstmt.close();
					   pstmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
		  return numberList;
	}
	
	
	
	protected static Map<String,String> getContantNumberMap(int type,int num){
		   Connection conn = null;
		   PreparedStatement pstmt = null;
		   ResultSet rs = null;
		   Map<String,String> map = new HashMap<String,String>();
		   try{
			   conn = ConnUtil.getConn();
			   String sql = "select * from interfaceman where type=?";
			   pstmt = conn.prepareStatement(sql);
			   pstmt.setInt(1, type);
			   rs = pstmt.executeQuery();			
			   while(rs.next()){
				   String interfaceName = rs.getString("interfaceName").trim();
				   String interfacePhone = rs.getString("interfacePhone").trim();
				   String interfaceEmail = rs.getString("interfaceEmail").trim();
				   switch(num){
				   case 1:				
					   map.put(interfaceName, interfaceEmail);
					   continue;
				   case 2:
					   map.put(interfaceName, interfacePhone);
					   continue;
				   case 3:
					   map.put(interfaceName, interfacePhone+"_"+interfaceEmail);
				   }				 
			   }
		   }catch(Exception e){
			   logger.error("getContantNumber error:",e);
		   }finally{
			   try{
				   if(rs != null){
					   rs.close();
					   rs = null;
				   }
				   if(pstmt != null){
					   pstmt.close();
					   pstmt = null;
				   }
				   if(conn != null){
					   conn.close();
					   conn = null;
				   }
			   }catch(Exception e){
				   e.printStackTrace();
			   }
		   }
		  return map;
	}
	
}
