package com.xunlei.niux.manager.web.servlet;

import com.xunlei.common.facade.IFacadeCommon;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;


public class UpLoadFileServlet extends HttpServlet {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static final Logger logger = Logger.getLogger(UpLoadFileServlet.class);

    /**
     * 图片上传地址
     * IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");
     */
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");
    
    private static final String APKPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadApkStorePath");

    /**
     * 同步图片命令
     */
    private static final String SYNCPICCOMMOND = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("syncPicCommond");

    /**
     * 同步APK命令
     */
    private static final String SYNCAPKCOMMOND = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("syncApkCommond");

    
    	
    private static final String APKDOWNLOADURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("apkDownLoadUrl");
    	
    /**
     * 远程图片地址
     */
    private static final String REMOTEPICSTOREPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remotePicStorePath");
    
    private static int imgDomainIndex=0;
    private static final String regix = "/<\\?php.*\\?>|<script.*>.*<\\/script>/isU";
    

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("upload  start................");

        // Create a factory for disk-based file items
        FileItemFactory factory = new DiskFileItemFactory();

        // 设置最多只允许在内存中存储的数据,单位:字节
        // factory.setSizeThreshold(4096);
        // 设置文件临时存储路径
        // factory.setRepository(new File("D:\\Temp"));

        // Create a new file upload handler
        ServletFileUpload upload = new ServletFileUpload(factory);

        // 设置路径、文件名的字符集
        upload.setHeaderEncoding("UTF-8");
        // 设置允许用户上传文件大小,单位:字节
        upload.setSizeMax(1024 * 1024 * 500);

        List<FileItem> items = null;
        try {
            items = upload.parseRequest(request);
        } catch (FileUploadException e) {
        	e.printStackTrace();
            logger.error("上传文件出错", e);
            error(response, e.toString());
        }

        System.out.println("upload  end................");
        //图片访问路径
        String fileUrl = "";
        // Process the uploaded items
        Iterator<FileItem> iter = items.iterator();
        while (iter.hasNext()) {
            FileItem item = iter.next();            
            String fileDir =  new SimpleDateFormat("yyyyMMdd").format(new Date());                
            String gameNo = "game";
            if (!item.isFormField()) {
                String filename = item.getName();
                String suffix = filename.substring(filename.lastIndexOf("."));
                File uploadedFile = null;
                if(".apk".equalsIgnoreCase(suffix)){//如果打包的是apk
            		String baseName = filename.substring(0,filename.lastIndexOf("."));
            		String names[] = baseName.split("_");
            		gameNo = names[0];
//                	File file = new File(APKPATH+gameNo+"/" + filename);
//                	if(file.exists()){//如果该文件已经存在    
//                		filename = baseName+"_"+(System.currentTimeMillis()/1000)+suffix;
//                	}
                	 File dir = new File(APKPATH+gameNo);
                	 if(!dir.exists()){
                		 dir.mkdirs();
                	 }
                	 uploadedFile = new File(APKPATH+gameNo+"/"  + filename);
                }else{
                    File uploadedDir = new File(FILEPATH + fileDir);                
                    if(!uploadedDir.exists()) {
                        uploadedDir.mkdirs();
                    }
                    filename = System.currentTimeMillis() + suffix;
                    uploadedFile = new File(FILEPATH  + fileDir + "/" + filename);
                }         
                FileInputStream fis = null;
                BufferedReader br = null;
                try {
                    item.write(uploadedFile);
                    
                    if(uploadedFile.getAbsolutePath().endsWith(".zip")){
                    	String indexFilePath=unzipAndDelete(uploadedFile.getAbsolutePath());
                    	File tempfile=new File(FILEPATH);
                    	fileUrl=getImgDomain()+indexFilePath.substring(tempfile.getAbsolutePath().length()+1);
                    }else{
                    	 fileUrl = getImgDomain() + fileDir + "/" + filename;
                    }
                    if(uploadedFile.getAbsolutePath().endsWith(".apk")){//apk同步
                    	//Runtime.getRuntime().exec(SYNCAPKCOMMOND+" "+APKPATH  + filename);
                    	fileUrl = APKDOWNLOADURL+gameNo+"/"  + filename;
                    }else{
                        Runtime.getRuntime().exec(SYNCPICCOMMOND+" "+FILEPATH + fileDir + "/" + filename);
                    }
             
                } catch (Exception e) {
                    logger.error("上传文件出错", e);
                    error(response, e.toString());
                }
            }
        }

        response.setCharacterEncoding("utf-8");
        PrintWriter writer = response.getWriter();
        writer.print("{\"success\":true, \"url\":\"" + fileUrl +"\"}");
        writer.flush();
        writer.close();

    }
    
    
    /**
     * 检查图片内容是否符合要求
     * @return
     */
    private boolean checkPhoto(){
    	
    	return true;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException("文件上传不支持GET方法");
    }

    private void error(HttpServletResponse response, String errorMessage) throws IOException {
        response.setCharacterEncoding("utf-8");
        PrintWriter writer = response.getWriter();
        errorMessage = URLEncoder.encode(errorMessage, "UTF-8");
        writer.print("{\"success\":false, \"message\":\"" + errorMessage +"\"}");
        writer.flush();
        writer.close();

        return;
    }
    /**
     * 获取图片静态域名
     * @return
     */
    public synchronized static String getImgDomain(){
    	imgDomainIndex++;
    	if(imgDomainIndex>3){
    		imgDomainIndex=0;
    	}
    	return "http://i"+imgDomainIndex+".webgame.kanimg.com/";
    }
    /**
     * 解压文件
     * @param zipFile
     * @throws IOException 
     */
    private static String unzipAndDelete(String zipFileName) throws IOException{
    	String indexFilePath="";
    	String unZipDirPath=zipFileName.substring(0,zipFileName.lastIndexOf("."));
    	ZipFile zipFile=new ZipFile(zipFileName);
    	Enumeration<?> emu=zipFile.entries();
    	while(emu.hasMoreElements()){
    		ZipEntry entry=(ZipEntry) emu.nextElement();
    		if(entry.isDirectory()){
    			new File(unZipDirPath+"/"+entry.getName()).mkdirs();
    			continue;
    		}
    		
    		BufferedInputStream bis=new BufferedInputStream(zipFile.getInputStream(entry));
    		File file=new File(unZipDirPath+"/"+entry.getName());
    		File parent=file.getParentFile();
    		if(parent!=null&&(!parent.exists())){
    			parent.mkdirs();
    		}
    		if(entry.getName().contains("index.")){
    			indexFilePath=file.getAbsolutePath();
    		}
    		int buffer=2048;
    		FileOutputStream fos=new FileOutputStream(file);
    		BufferedOutputStream bos=new BufferedOutputStream(fos,buffer);
    		int count=-1;
    		byte data[]=new byte[buffer];
    		while((count=bis.read(data,0,buffer))!=-1){
    			bos.write(data,0,count);
    		}
    		bos.flush();
    		bos.close();
    		bis.close();
    	}
    	//关闭文件
    	zipFile.close();
    	//删除文件
    	File file=new File(zipFileName);
    	file.delete();
    	return indexFilePath;
    }
}
