package com.xunlei.niux.manager.web.servlet;

import com.xunlei.common.facade.IFacadeCommon;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ActionHandlerServlet extends HttpServlet {
    private static final Logger logger = Logger.getLogger(ActionHandlerServlet.class);
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doPost(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        if(StringUtils.isEmpty(action)){
            resp.setCharacterEncoding("utf-8");
            PrintWriter writer = resp.getWriter();
            writer.print("{\"success\":false, \"message\":\"missing action\"}");
            writer.flush();
            writer.close();
        }

        if("getUid".equals(action)){
            getUid(req,resp);
        }

    }

    private void getUid(HttpServletRequest request, HttpServletResponse response) throws IOException{
        logger.info("start uploading uid file...");
        FileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload(factory);
        upload.setHeaderEncoding("UTF-8");
        upload.setSizeMax(1024 * 1024 * 500);
        List<FileItem> items = null;
        try {
            items = upload.parseRequest(request);
        } catch (FileUploadException e) {
            e.printStackTrace();
            logger.error("上传文件出错", e);
            error(response, e.toString());
        }

        String text = "";
        Iterator<FileItem> iter = items.iterator();
        while (iter.hasNext()) {
            FileItem item = iter.next();
            String fileDir =  new SimpleDateFormat("yyyyMMdd").format(new Date());
            if (!item.isFormField()) {
                String filename = item.getName();
                String suffix = filename.substring(filename.lastIndexOf("."));
                File uploadedFile = null;
                    File uploadedDir = new File(FILEPATH + fileDir);
                    if(!uploadedDir.exists()) {
                        uploadedDir.mkdirs();
                    }
                    filename = System.currentTimeMillis() + suffix;
                    uploadedFile = new File(FILEPATH  + fileDir + "/" + filename);

                try {
                    item.write(uploadedFile);
                    text+=importTxt(FILEPATH  + fileDir + "/" + filename);
                } catch (Exception e) {
                    logger.error("上传文件出错", e);
                    error(response, e.toString());
                }
            }
        }
        logger.info("upload result:"+text);
        response.setCharacterEncoding("utf-8");
        PrintWriter writer = response.getWriter();
        writer.print("{\"success\":true, \"url\":\"" + text +"\"}");
        writer.flush();
        writer.close();

    }

    /**
     * 导入txt文件
     */
    private String importTxt(String filename) throws Exception{
        String text="";
        FileInputStream fis = null;
        BufferedReader br = null;
        try{
            fis = new FileInputStream(filename);
            br = new BufferedReader(new InputStreamReader(fis));
            String readline = br.readLine();
            while(readline != null){
                String uid = readline.trim();
                text+=uid+"|";
                readline = br.readLine();
            }
        }catch(Exception e){
            throw e;
        }finally{
            try{
                if(br != null){
                    br.close();
                    br = null;
                }
                if(fis != null){
                    fis.close();
                    fis = null;
                }
            }catch(Exception e){
                e.printStackTrace();
            }
        }
        return text;
    }

    private void error(HttpServletResponse response, String errorMessage) throws IOException {
        response.setCharacterEncoding("utf-8");
        PrintWriter writer = response.getWriter();
        errorMessage = URLEncoder.encode(errorMessage, "UTF-8");
        writer.print("{\"success\":false, \"message\":\"" + errorMessage +"\"}");
        writer.flush();
        writer.close();

        return;
    }
}
