package com.xunlei.niux.manager.web.proxy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.util.StringTools;

public class SynchIndexPageToBoxProxy {
	private static final Logger logger = Logger.getLogger(SynchIndexPageToBoxProxy.class.getName());	
	private static final String boxDataUrl =  IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("boxDataUrl");	
	private static SynchIndexPageToBoxProxy instance = new SynchIndexPageToBoxProxy();
	private static final String activityCmd = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestCmd");	
	
	 public void sync(){
		 try {
			 logger.info("开始盒子首页图片文件,地址:/usr/local/bin/"+activityCmd);
			 Runtime.getRuntime().exec("/usr/local/bin/"+activityCmd);			
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	 }
	
	private SynchIndexPageToBoxProxy(){
		
	}
	
	public static SynchIndexPageToBoxProxy getInstance(){
		return instance;
	}
	
	
	
	public void makeData(){
		//猜你喜欢
		String jsonStr=JsonObjectUtil.getDataJsonObject(getGuessList());
		jsonStr = "var GUESS_LIST="+jsonStr+";";
		//近日火爆区服
		String jsonStr2=JsonObjectUtil.getDataJsonObject(getHotServerBannerList());
		jsonStr = jsonStr+"var HOT_SERVER_LIST="+jsonStr2+";";
		//首页flash广告
		String jsonStr3=JsonObjectUtil.getDataJsonObject(getIndexPageFlash());
		jsonStr = jsonStr+"var INDEX_FLASH="+jsonStr3+";";
		File file = FileUtil.createFile(boxDataUrl,"indexpage.js");
		FileUtil.writeByChar(file, jsonStr);				
		//同步数据
		sync();
	}
	
	 private Map<String,Object> getIndexPageFlash(){
		 Map<String,Object> result = new  HashMap<String,Object>();
	   	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().getLinkListByOrderByLimit("1516", "validdatetime", OrderType.DESC, false);
	   	 if(CollectionUtils.isEmpty(linkInfoList)){
	   		 return result;
	   	 }
	   	LinkInfo info = linkInfoList.get(0);
	   	String gameid = info.getGameidbytuijian();
	   	String linkurl = info.getLinkurl();
	   	if(StringTools.isEmpty(linkurl)){
	   		result.put("gameid", gameid);		  
	   		result.put("opentype", 2);
	   	}else{
		   	result.put("url", linkurl);
		   	result.put("opentype", 1);
	   	}
		result.put("pic", info.getPicurl());
		result.put("id", info.getLinkid());
		 return result;
	 }
	
	
    private List<Map<String,Object>> getHotServerBannerList(){
	   	 List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
	   	 List<LinkInfo> linkInfoList =  FacadeFactory.INSTANCE.getLinkInfoBo().getLinkListByOrderByLimit("1509", "displaysort", OrderType.ESC, false);
	   	 if(CollectionUtils.isEmpty(linkInfoList)){
	   		 return result;
	   	 }
	   	 for(LinkInfo info:linkInfoList){
	   		 Map<String,Object> map = new HashMap<String,Object>();
	   		 String gameid = info.getGameidbytuijian();
	   		 if(StringTools.isEmpty(gameid))continue;   
	   		 Games game = GameCache.getInstance().getGameByGameId(gameid);
	   		 map.put("gameNo", game.getGameNo());
	   		 map.put("gameid", gameid);
	   		 map.put("title", info.getLinktitle());
	   		 map.put("pic", info.getPicurl());
	   		 map.put("url", info.getLinkurl());
	   		 result.add(map);
	   	 }
	   	return result;
   }
	
	private List<Map<String,Object>> getGuessList(){
		List<Map<String,Object>> datalist = new ArrayList<Map<String,Object>>();
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1502");//搜索页猜你喜欢
	    Page page = new Page();
	    page.setPageNo(1);
	    page.setPageSize(4);
	    page.addOrder("validdatetime", OrderType.DESC);//按照生效时间逆序
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);	    	    
		for(LinkInfo info:list){			
			Map<String,Object> map = new HashMap<String,Object>();
			String gameId = info.getGameidbytuijian();
			Games games = GameCache.getInstance().getGameByGameId(gameId);
			map.put("gameName", games.getGameName());
			map.put("gameNo", games.getGameNo());
			map.put("gameId", games.getGameId());
			map.put("content", info.getLinkdesc());
			map.put("bgImg", games.getPicUrl()==null?"":games.getPicUrl());
			//map.put("gameOfficialUrl", games.getOfficialWebSite());
			datalist.add(map);
		}
		return datalist;
	}
}
