package com.xunlei.niux.manager.web.proxy;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.manager.web.util.ShortUrlCreater;

public class SpreadInfoProxy {
	private static final String DOMAIN = "http://jump.niu.xunlei.com:8080/";	
	private static final String GAME_TAB = "官网";
	private static final String GAME_FLATNO = "官网渠道";
	
	private static final SpreadInfoProxy instance = new SpreadInfoProxy();
	
	private SpreadInfoProxy(){
		
	}
	public static SpreadInfoProxy getInstance(){
		return instance;
	}
	
	public String getAdvNo(Games games){
		Spreadinfo query = new Spreadinfo();
		query.setSpreadTab(games.getGameName()+GAME_TAB);
		query.setFlatno(GAME_FLATNO);
		Spreadinfo info = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(info==null){
			info  = new Spreadinfo();
		    info.setFlatno(GAME_FLATNO);
		    try {
				info.setAdvNo(ShortUrlCreater.createAdvNo());
			} catch (Exception e) {
				return null;
			}
		    info.setShorturl(DOMAIN+ ShortUrlCreater.createShortUrl(games.getOfficialWebSite()));
		    info.setJumpurl(games.getOfficialWebSite());
		    checkAdvNo(info);
		    info.setChooseWeight(0L);
		    info.setInputBy("系统");
		    info.setInputTime(DateUtil.formatNowByDefault());
		    info.setStatus(true);
			info.setSpreadTab(games.getGameName()+GAME_TAB);
			FacadeFactory.INSTANCE.getBaseSo().addObject(info);
		}
		
		return info.getAdvNo();
	}
	
	  private void checkAdvNo(Spreadinfo spreadInfo) {
	        String jumpurl = spreadInfo.getJumpurl();
	        String advNoStr = "advNo=" + spreadInfo.getAdvNo();

	        if (!jumpurl.contains(advNoStr)) {
	            if (jumpurl.endsWith("/")) {
	                jumpurl += "?" + advNoStr;
	            } else if (jumpurl.endsWith("?")) {
	                jumpurl += advNoStr;
	            } else if (!jumpurl.contains("?")) {
	                jumpurl += "?" + advNoStr;
	            } else {
	                jumpurl += "&" + advNoStr;
	            }

	            spreadInfo.setJumpurl(jumpurl);
	        }
	    }
}
