package com.xunlei.niux.manager.web.proxy;

import com.xunlei.niux.data.vipgame.vo.workflow.WorkUser;



public interface IBaseAuth {

	
	/**
	 * 检查用户是否具备指定流程指定顺序的权限
	 * @param flowNo 指定流程
	 * @param order  指定的审核顺利
	 * @param account 指定账号
	 * @return
	 */
	public boolean checkUser(String flowNo,int order, String account);
	
	/**
	 * 检查用户的权限，如果没有权限，则抛异常
	 * @param flowNo
	 * @param wporderid
	 * @param account
	 * @throws Exception
	 */
	public void checkUser(String flowNo,String wporderid,String account) throws Exception;
	
	
	/**
	 * 查询该账号是否是最后一个审核人
	 * @param flowNo
	 * @param wporderid
	 * @param account
	 * @return
	 */
	public boolean isLastChecker(String flowNo,String wporderid,String account);
	
	
	/**
	 * 记录审核过程
	 * @param flowNo
	 * @param wporderid
	 * @param account
	 * @param status
	 * @param reason
	 */
	public void record(String flowNo,String wporderid,String account,String time,int status,String reason);
	
	
	 /**
	  * 发送邮件
	  * @param time
	  * @param title
	  * @param content
	  * @param receivers
	  * @throws Exception
	  */
	 public void sendMail(String time,String title,StringBuffer content,String ...receivers) throws Exception;
	
	 /**
	  * 获得单据的第一个审核人
	  * @param flowNo
	  * @param wporderid
	  * @return
	  */
	 public String getFirstChecker(String flowNo,String wporderid);
	 
	 /**
	  * 获得目前该单据的最后一个审核人
	  * @param flowNo
	  * @param wporderid
	  * @return
	  */
	 public String getLastChecker(String flowNo,String wporderid);
	 
	 /**
	  * 获得目前该单据的下一个审核人
	  * @param flowNo
	  * @param wporderid
	  * @return
	  */
	 public String getNextChecker(String flowNo,String wporderid);
	 
	 /**
	  * 审核不通过时，设置之前的审核记录为无效，以便可以再次审核
	  * @param flowNo
	  * @param wporderid
	  */
	 public void invalidRecord(String flowNo, String wporderid);
	 
	 /**
	  * 获得审核人信息
	  * @param flowNo
	  * @param account
	  * @return
	  */
	 public WorkUser getWorkUser(String flowNo,String account);
	 
	 /**
	  * 获得审核人迅雷邮箱
	  * @param account
	  * @return
	  */
	 public String getEmailFromName(String account);

    /**
     * 判断是否为该流程指定顺序审核人
     * @param flowNo
     * @param displayOrder
     * @param account
     * @return
     */
	 public boolean isSpecialDisplayOrder(String flowNo, int displayOrder, String account);
}
