package com.xunlei.niux.manager.web.proxy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.file.XmlUtil;

public class GameXmlProxy {
     private static final String SYNCPICCOMMOND = "rsync_niuofficial_formal.sh";
     private static final String MAKEGAMESERVERDATA = "make_game_server_data_test.sh";
     private static final GameXmlProxy  instance = new GameXmlProxy();
     private  static final Games GAME = new Games();
     private static final GameServers GAMESERVER = new GameServers();
     private static final String ROOTPATH = "/usr/local/templatedata/formal/gamesevers/"; //存放生成xml文件的根目录
     private static final String BASEURL = "http://niu.xunlei.com/gameservers/";//远程服务器xml可访问的基础url 
     private  static final Page PAGE = new Page();

     
     private GameXmlProxy(){
         
     }
     
     public static GameXmlProxy getInstance(){
    	 return instance;
     }
     
     /**
      * 将xml文件中的数据插入测试环境数量库中
      * @throws Exception
      */
     public void makeData() throws Exception{
    	 //下载远程sql文件
    	 download();
    	 //执行导入数据的脚本
    	 Runtime.getRuntime().exec("/usr/local/bin/"+MAKEGAMESERVERDATA);			
     }
     
         
     private void download() throws Exception{
    	 download("games.sql");
    	 download("gameservers.sql");
     }
     
     /**
      * 从远程服务器上下载sql文件到测试服务器
      * @throws Exception
      */
     private void download(String fileName) throws Exception{
    	 URL url = new URL(BASEURL+fileName);
    	 InputStream is = url.openStream();
    	 FileOutputStream fos = null;
    	 try{
    		 fos = 	new FileOutputStream(ROOTPATH+fileName);
    		 int code = is.read();
    		 while(code != -1){
    			 fos.write(code);
    			 code = is.read();
    		 }
    		 fos.flush();
    	 }catch(Exception e){
    		 throw e;
    	 }finally{
    		 try{
    			 if(fos != null){
    				 fos.close();
    				 fos = null;
    			 }
    			 if(is != null){
    				 is.close();
    				 is = null;
    			 }
    		 }catch(Exception e){
    			 throw e;
    		 }
    	 }   	 
     }
     
     /**
 	 * 将数据生成xml文件
 	 * @return
 	 */
 	public void makeXml() throws Exception{
 		//获得所有游戏信息
 		List<Games> gameslist = FacadeFactory.INSTANCE.getGamesBo().findGames(GAME, PAGE);
 		for(Games games:gameslist)
 			makeGameXmlFile(ROOTPATH+"games.xml",games);
 		//获得所有游戏的区服信息
 		List<GameServers> gameserverslist = FacadeFactory.INSTANCE.getGameServersBo().find(GAMESERVER, PAGE);
 		for(GameServers server:gameserverslist)
 			makeGameServerXmlFile(ROOTPATH+"gameservers.xml",server);
 		//同步文件
 		synchGame();
 	}
 	
 	public void makeSql() throws Exception{
 		makeGames();
 		makeGameServers();
 		//同步文件
 		synchGame();
 	}
 	
	/**
	 * 同步游戏xml
	 * @throws Exception
	 */
	private void synchGame() throws Exception{
		Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);			
	}
 	
 	/**
 	 * 生成游戏xml
 	 * @param fileName
 	 * @param games
 	 * @throws Exception
 	 */
 	private void makeGameXmlFile(String fileName,Games games) throws Exception {
 		String keyName = "id";
 		String keyValue = games.getGameId();
 		String tagName = "game";
 		Map<String,String> attMap = new LinkedHashMap<String,String>();//子标签属性
 		attMap.put("name", games.getGameName());
 		attMap.put("id", games.getGameId());
 		Map<String,String> proMap = new LinkedHashMap<String,String>(); //下级标签 名称 和 值
 		proMap.put("seqId", games.getSeqId()+"");
 		proMap.put("gameNo", games.getGameNo());
 		proMap.put("gameDesc", games.getGameDesc());
 		proMap.put("gameType", games.getGameType());
 		proMap.put("runStatus",games.getRunStatus());
 		proMap.put("officialWebSite", games.getOfficialWebSite());
 		proMap.put("displayOrder", games.getDisplayOrder()+"");
 		proMap.put("status", games.getStatus());
 		proMap.put("remark", games.getRemark());
 		proMap.put("inputBy", games.getInputBy());
 		proMap.put("inputTime", games.getInputTime());
 		proMap.put("editBy", games.getEditBy());
 		proMap.put("editTime", games.getEditTime());
 		proMap.put("forumUrl", games.getForumUrl());
 		proMap.put("useTemplate", games.getUseTemplate()+"");
 		proMap.put("clientType", games.getClientType()+"");
 		proMap.put("loadClientType", games.getLoadClientType()+"");
 		proMap.put("hasBigFenQu", games.getHasBigFenQu()+"");
 		proMap.put("payUrl", games.getPayUrl());
 		proMap.put("simpleName", games.getSimpleName());
 		//生成xml文件
 		XmlUtil.commonOneLevelXml(fileName, tagName, keyName, keyValue, attMap, proMap);
 	}
 	
 	/**
 	 * 生成游戏区服xml
 	 * @param fileName
 	 * @param server
 	 * @throws Exception
 	 */
 	private void makeGameServerXmlFile(String fileName,GameServers server) throws Exception {
 		String keyName = "id";
 		String keyValue = server.getServerId();
 		String tagName = "gameserver";
 		Map<String,String> attMap = new LinkedHashMap<String,String>();//子标签属性
 		attMap.put("id", server.getServerId());
 		Map<String,String> proMap = new LinkedHashMap<String,String>(); //下级标签 名称 和 值
 		proMap.put("gameId", server.getGameId());
 		proMap.put("fenQuNum", server.getFenQuNum()+"");
 		proMap.put("fenQuName", server.getFenQuName());
 		proMap.put("serverId",server.getServerId());
 		proMap.put("serverName", server.getServerName());
 		proMap.put("openstatus", server.getOpenStatus());
 		proMap.put("openTime", server.getOpenTime());
 		proMap.put("remark", server.getRemark());
 		proMap.put("inputBy", server.getInputBy());
 		proMap.put("inputTime", server.getInputTime());
 		proMap.put("editBy", server.getEditBy());
 		proMap.put("editTime", server.getEditTime());
 		proMap.put("address", server.getAddress());
 		proMap.put("isrecommand",server.getIsrecommand()+"");
 		proMap.put("isnew", server.getIsnew()+"");
 		proMap.put("redtitle", server.getRedtitle()+"");
 		proMap.put("fenQuNickName", server.getFenQuName());
 		proMap.put("bigFenQuName", server.getBigFenQuName());
 		//生成xml文件
 		XmlUtil.commonOneLevelXml(fileName, tagName, keyName, keyValue, attMap, proMap);
 	}
 	
 	private String getGamesSQL(Games games) throws Exception {
 		StringBuffer sb = new StringBuffer("insert into games  values('");
 		sb.append(games.getSeqId()).append("','")
 		.append(games.getGameName()).append("','")
 		.append(games.getGameNo()).append("','")
 		.append("").append("','")
 		.append(games.getGameType()).append("','")
 		.append(games.getRunStatus()).append("','")
 		.append(games.getOfficialWebSite()).append("','")
 		.append(games.getCoparnterId()).append("','")
 		.append(games.getDisplayOrder()).append("','")
 		.append(games.getStatus()).append("','")
 		.append(games.getRemark()).append("','")
 		.append(games.getInputBy()).append("','")
 		.append(games.getInputTime()).append("','")
 		.append(games.getEditBy()).append("','")
 		.append(games.getEditTime()).append("','")
 		.append(games.getGameId()).append("','")
 		.append(games.getForumUrl()).append("','")
 		.append("").append("','")
 		.append("").append("','")
 		.append("0").append("','")
 		.append(games.getUseTemplate()?"1":"0").append("','")
 		.append(games.getClientType()).append("','")
 		.append(games.getLoadClientType()).append("','")
 		.append(games.getHasBigFenQu()?"1":"0").append("','")
 		.append(games.getPayUrl()).append("','")
 		.append(games.getSimpleName()).append("');");
 		return sb.toString();
 	}
 	
 	private String getGameServersSQL(GameServers server) throws Exception {
 		StringBuffer sb = new StringBuffer("insert into gameservers  values('");
 		sb.append(server.getSeqId()).append("','")
 		.append(server.getGameId()).append("','")
 		.append(server.getFenQuNum()).append("','")
 		.append(server.getFenQuName()).append("','")
 		.append(server.getServerId()).append("','")
 		.append(server.getServerName()).append("','")
 		.append(server.getOpenStatus()).append("','")
 		.append(server.getOpenTime()).append("','")
 		.append(server.getRemark()).append("','")
 		.append(server.getRemark()).append("','")
 		.append(server.getInputBy()).append("','")
 		.append(server.getInputTime()).append("','")
 		.append(server.getEditBy()).append("','")
 		.append(server.getEditTime()).append("','")
 		.append(server.getAddress()).append("','")
 		.append(server.getIsrecommand()?"1":"0").append("','")
 		.append(server.getIsnew()?"1":"0").append("','")
 		.append(server.getRedtitle()?"1":"0").append("','")
 		.append(server.getFenQuNickName()).append("','")
 		.append(server.getBigFenQuName()).append("');");
 		return sb.toString();
 	}
 	
	private void makeGameServers() throws Exception{
 		File file = new File(ROOTPATH+"gameservers.sql");
 		if(file.exists()){
 			file.createNewFile();
 		}
 		FileOutputStream fos = null;
 		BufferedWriter bw = null;
 		try{
 			 fos = new FileOutputStream(file);
 			 bw = new BufferedWriter(new OutputStreamWriter(fos));
 			 bw.write("delete from gameservers ;");
 			 bw.write("\n");
 			//获得所有游戏信息
 			//获得所有游戏的区服信息
 	 		List<GameServers> gameserverslist = FacadeFactory.INSTANCE.getGameServersBo().find(GAMESERVER, PAGE);
 	 		for(GameServers server:gameserverslist){
 	 			bw.write(getGameServersSQL(server)); 	
 	 			bw.write("\n");
 	 		}
 	 					 
 			bw.flush();
 		}catch(Exception e){
 			throw e;
 		}finally{
 			try{
 				if(bw != null){
 					bw.close();
 					bw = null;
 				}
 				if(fos != null){
 					fos.close();
 					fos = null;
 				}
 			}catch(Exception e){
 				throw e;
 			}
 		}
 	}
 	private void makeGames() throws Exception{
 		File file = new File(ROOTPATH+"games.sql");
 		if(file.exists()){
 			file.createNewFile();
 		}
 		FileOutputStream fos = null;
 		BufferedWriter bw = null;
 		try{
 			 fos = new FileOutputStream(file);
 			 bw = new BufferedWriter(new OutputStreamWriter(fos));
 			 bw.write("delete from games ;");
 			 bw.write("\n");
 			//获得所有游戏信息
 	 		List<Games> gameslist = FacadeFactory.INSTANCE.getGamesBo().findGames(GAME, PAGE);
 	 		for(Games games:gameslist){
 	 			bw.write(getGamesSQL(games)); 	
 	 			bw.write("\n");
 	 		}
 	 					 
 			bw.flush();
 		}catch(Exception e){
 			throw e;
 		}finally{
 			try{
 				if(bw != null){
 					bw.close();
 					bw = null;
 				}
 				if(fos != null){
 					fos.close();
 					fos = null;
 				}
 			}catch(Exception e){
 				throw e;
 			}
 		}
 	}
}
