package com.xunlei.niux.manager.web.proxy;

import com.xunlei.niux.manager.web.util.HttpClientUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class GameUserInfoProxy {

    private static final Logger logger = Logger.getLogger(GameUserInfoProxy.class.getName());
    private static String queryUserInfoUrl = "http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo";

    public static Long getUidByAccount(String account){
        Long uid = 0L;
        try {
            String url = queryUserInfoUrl+"?gameid=0&type=300&accounts="+account;
            logger.info("GameUserInfoProxy查找uid"+url);
            String rr = HttpClientUtil.get(url);
            logger.info("GameUserInfoProxy查找uid返回"+rr);
            JSONObject uidJson = new JSONObject(rr);
            String statues = uidJson.getString("statues");
            if(!"0".equals(statues)){
                return 0L;
            }
            String result = uidJson.getString("result");
            uid= Long.valueOf(result.split("=")[1]);
        } catch (Exception e) {
            logger.error("getUidByAccount Exception ",e);
        }
        return uid;
    }

    public static String getAccountByUid(Long uid) {
        String account = "";
        try {
            String url = queryUserInfoUrl+"?gameid=0&type=600&accounts="+uid;
            logger.info("GameUserInfoProxy查找账号"+url);
            String rr = HttpClientUtil.get(url);
            logger.info("GameUserInfoProxy查找账号返回"+rr);
            JSONObject uidJson = new JSONObject(rr);
            String statues = uidJson.getString("statues");
            if(!"0".equals(statues)){
                return "";
            }
            String result = uidJson.getString("result");
            account= result.split("=")[1];
        } catch (Exception e) {
            logger.error("getAccountByUid Exception ",e);
        }
        return account;
    }
}
