package com.xunlei.niux.manager.web.proxy;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.manager.web.util.FileUtil;

public class BaseProxy {
	private static final Logger logger = Logger.getLogger(BaseProxy.class.getName());	
	
	 public void sync(String cmdName){
		 try {
			 logger.info("开始同步文件,地址:/usr/local/bin/"+cmdName);
			 Runtime.getRuntime().exec("/usr/local/bin/"+cmdName);		
			 logger.info("同步文件完毕,地址:/usr/local/bin/"+cmdName);
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	 }
	 
	 public void makeFile(Object data,String path,String fileName,String param,String cmdName){
		 	logger.info("开始生成文件："+fileName);
			String jsonStr=JsonObjectUtil.getDataJsonObject(data);
			jsonStr = param+jsonStr;//可以加额外的参数，如：var GAME_SERVER_ACTIVITY_COUNT=
			File file = FileUtil.createFile(path,fileName);
			FileUtil.writeByChar(file, jsonStr);		
			logger.info("生成文件完毕："+fileName);
	 }
	 
	 
	 public void makeData(Object data,String path,String fileName,String param,String cmdName){
		 makeFile(data,path,fileName,param,cmdName);
		 sync(cmdName);
	 }
	 
}
