package com.xunlei.niux.manager.web.model.vip;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserRebateDateRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-10-22
 * Time: 下午5:37
 * To change this template use File | Settings | File Templates.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_USERREBATEDATERECORD)
public class UserRebateDateRecordManagedBean extends BaseManagedBean {
    private final Logger logger = Logger.getLogger(this.getClass());

    public String getUserRebateDateRecordList(){
        logger.debug("开始用户返利查询");
        this.authenticateRun();//验证运行权限
        UserRebateDateRecord userRebateDateRecord=this.findBean(UserRebateDateRecord.class,"userrebatedaterecord");
        if(userRebateDateRecord!=null){
            logger.debug("user Rebate Date Record "+userRebateDateRecord.getSeqId());
        }
        PagedFliper pagedFliper =this.getFliper();
        int count= FacadeFactory.INSTANCE.getBaseBo().countObject(userRebateDateRecord);
        List<UserRebateDateRecord> list=new ArrayList<UserRebateDateRecord>();

        if(count>0){
            Page page= PageUtil.formatPage(pagedFliper, "recordDate", "desc", "gameId", "asc");
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list=FacadeFactory.INSTANCE.getBaseBo().findObjects(userRebateDateRecord,page);
        }
        Sheet<UserRebateDateRecord> sheet=new Sheet<UserRebateDateRecord>(count,list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

}
