package com.xunlei.niux.manager.web.model.vip;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.vip.PropOrder;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.PageUtil;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-10-25
 * Time: 下午2:39
 * To change this template use File | Settings | File Templates.
 */
public class PropOrderManagedBean extends BaseManagedBean {
    private static Map<Integer,String> payTypeMap;
    private static Map<Integer,String> orderStatusMap;
    private static Map<Integer,String> noticeStatusMap;

    /**
     * 查询用户返利信息
     * @return
     */
    public String getPropOrderList(){
        logger.debug("开始道具充值记录查询");
        this.authenticateRun();//验证运行权限
        PropOrder propOrder=this.findBean(PropOrder.class,"proporder");
        if(propOrder!=null){
            logger.debug("Prop order "+propOrder.getOrderId());
            if(propOrder.getStatus()!=null && propOrder.getStatus()==-1){
                propOrder.setStatus(null);
            }
            if(propOrder.getIsNotice()!=null && propOrder.getIsNotice()==-1){
                propOrder.setIsNotice(null);
            }
        }
        PagedFliper pagedFliper =this.getFliper();
        int count= FacadeFactory.INSTANCE.getBaseSo().countObject(propOrder);
        List<PropOrder> list=new ArrayList<PropOrder>();

        if(count>0){
            Page page= PageUtil.formatPage(pagedFliper, "seqid", "desc");
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list=FacadeFactory.INSTANCE.getBaseSo().findObjects(propOrder,page);
        }
        Sheet<PropOrder> sheet=new Sheet<PropOrder>(count,list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String edit(){
        System.out.println("edit");
        this.authenticateEdit();//添加权限
        PropOrder propOrder=this.findBean(PropOrder.class,"proporder");

        UserInfo userInfo = currentUserInfo();
        propOrder.setEditBy(userInfo.getTrueName());

        Date now = new Date();
        String editTime = sdf_time.format(now);
        propOrder.setEditTime(editTime);

        try{
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(propOrder);
        }catch(Exception e){
            logger.error("编辑PropOrder失败",e);
            this.mergeJsmessage("编辑失败，原因："+e.getMessage());
        }
        return "";
    }

    public Map<Integer,String> getPayTypeMap(){
        if(payTypeMap==null){
            payTypeMap = new HashMap<Integer,String>();
            payTypeMap.put(1,"网银");
            payTypeMap.put(2,"雷点");
            payTypeMap.put(3,"支付宝");
        }
        return payTypeMap;
    }

    public Map<Integer,String> getOrderStatusMap(){
        if(orderStatusMap==null){
            orderStatusMap = new HashMap<Integer, String>();
            orderStatusMap.put(0,"支付失败");
            orderStatusMap.put(1,"支付成功");
        }
        return orderStatusMap;
    }

    public Map<Integer,String> getNoticeStatusMap(){
        if(noticeStatusMap==null){
            noticeStatusMap = new HashMap<Integer, String>();
            noticeStatusMap.put(0,"未投放");
            noticeStatusMap.put(1,"已投放");
        }

        return noticeStatusMap;
    }
}
