package com.xunlei.niux.manager.web.model.vip;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.common.vo.Users;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.ManualRechargeRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.proxy.CheckGiftMoneyProxy;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.PageUtil;

@FunRef("ManualRecharge")
public class ManualRechargeManagedBean extends BaseManagedBean {
	private static final String rebatecheckers = EnvPropertyUtil.loadProperty("niux","rebatecheckers");
	private UploadedFile uploadedFile;

	public UploadedFile getUploadedFile() {
		return uploadedFile;
	}

	public void setUploadedFile(final UploadedFile uploadedFile) {
		this.uploadedFile = uploadedFile;
	}

	public String getQueryManualRechargeRecords() {
		this.authenticateRun();// 验证运行权限 
		ManualRechargeRecord rechargeRecord = this.findBean(ManualRechargeRecord.class,
				"manualRechargeRecord");
		int count = FacadeFactory.INSTANCE.getBaseBo().countObject(rechargeRecord);
		if (count == 0) {
			return mergePagedDataModel(0, new ArrayList<ManualRechargeRecord>());
		}
		Page page = PageUtil.formatPage(this.getFliper(), "seqId", "desc");
		List<ManualRechargeRecord> list = FacadeFactory.INSTANCE.getBaseBo()
				.findObjects(rechargeRecord, page);
		mergePagedDataModel(count, list);
		return "";
	}

	public String doImport() {
		this.authenticateAdd();
		UserInfo userInfo = currentUserInfo();
		try {
			String remark = findParameter("one_reason");
			List<ManualRechargeRecord> records = parseUploadedFile(uploadedFile);			
			String importLot = String.valueOf(System.currentTimeMillis());
			String inputTime = sdf_time.format(new Date());
			String nowday = inputTime.split(" ")[0];//当前日期
			ManualRechargeRecord query = new ManualRechargeRecord();
			query.setFromInputTime(nowday+" 00:00:00");
			query.setToInputTime(nowday+" 24:00:00");
			query.setInputBy(userInfo.getTrueName());
			List<ManualRechargeRecord>  mrrlist = FacadeFactory.INSTANCE.getBaseBo().findObjects(query, new Page());
			long historyMoney = 0L;//当前历史总金额
			long money = 0L;//该批次总金额			
			for(ManualRechargeRecord record :records){
				money += record.getMoney();
			}
			for(ManualRechargeRecord mrr:mrrlist){
				if("NOTPASS".equals(mrr.getCheckStatus())){//审核未通过的不用计算在内
				    continue;
			    }
				historyMoney += mrr.getMoney();
			}		
			for (int i = 0; i < records.size(); i++) {
				ManualRechargeRecord record = records.get(i);
				record.setImportLot(importLot);
				record.setInputBy(userInfo.getTrueName());
				record.setInputTime(inputTime);
				record.setRechargeStatus("WAIT");
				record.setCheckStatus("WAIT");
				record.setRemark(remark);
				if(historyMoney + money <= 10){//录入人自己审核
					record.setChecker(currentUserLogo());
				}else if(historyMoney + money >10 && historyMoney + money < 5000){
					
					String checkers = getCheckersByRoleNo("NIUX_0551");
					
					if(StringUtils.isEmpty(checkers)){
						record.setChecker(rebatecheckers.split(",")[0].trim());
					}else{
						record.setChecker(checkers);
					}
					
				}else{
					String checkers = getCheckersByRoleNo("NIUX_0552");
					if(StringUtils.isEmpty(checkers)){
						record.setChecker(rebatecheckers.split(",")[1].trim());
					}else{
						record.setChecker(checkers);
					}
				}
				FacadeFactory.INSTANCE.getBaseBo().addObject(record);
			}
		} catch (Exception e) {
			logger.error("上传失败", e);
			mergeJsmessage("用户" + userInfo.getTrueName() + "上传失败：" + e.getMessage());
		}
		uploadedFile=null;
		return "";
	}

	/**
	 * 根据roleno找到所有用户,获得所有用户的userlogon转成xxx|xxx|xxx|字符串
	 * @param roleNo
	 * @return
	 */
	private String getCheckersByRoleNo(final String roleNo){
		Roles role = new Roles();
		role.setRoleno(roleNo);
	    role.setRoletype("SYS");
	    List<Users> userList = commfacade.getAllUsersInRoles(role);
	    if(userList != null && !userList.isEmpty()){
	    	StringBuilder users = new StringBuilder();
	    	for(Users user : userList){
	    		users.append(user.getUserlogno().trim()).append(",");
	    	}
	    	return users.toString();
	    }else{
	    	return null;
	    }
	}
	
	public List<ManualRechargeRecord> parseUploadedFile(final UploadedFile file) throws Exception {
		if (file == null) {
			throw new XLRuntimeException("上传文件为空");
		}
		String uploadedStr = new String(file.getBytes(), "GBK");
		if (uploadedStr == null || "".equals(uploadedStr)) {
			throw new XLRuntimeException("上传文件内容为空");
		}
		// 统一换行符
		uploadedStr = uploadedStr.replaceAll("\r\n", "\r");
		uploadedStr = uploadedStr.replaceAll("\n", "\r");
		String[] lineStrs = uploadedStr.split("\r");
		List<ManualRechargeRecord> records = new ArrayList<ManualRechargeRecord>();
		if (lineStrs == null || lineStrs.length == 0) {
			throw new XLRuntimeException("上传文件内容0行");
		}
		for (String lineStr : lineStrs) {
			if (lineStr == null || "".equals(lineStr)) {
				continue;
			}
			logger.info(lineStr);
			String[] temps = lineStr.split("\\t");
			if (temps.length != 5) {
				throw new XLRuntimeException("格式错误");
			}
			ManualRechargeRecord record = new ManualRechargeRecord();
			record.setUserId(temps[0]);
			record.setMoney(Integer.valueOf(temps[1]));
			record.setGameId(temps[2]);
			if(StringTools.isEmpty(record.getGameId())){
				throw new XLRuntimeException("游戏编号为空");
			}
			if(record.getGameId().length()!=5&&record.getGameId().length()!=6){
				throw new XLRuntimeException("游戏编号不正确");
			}
			if(record.getGameId().length()==5){
				record.setGameId("0"+record.getGameId());
			}
			record.setServerId(temps[3]);
			record.setRoleId(temps[4]);
			records.add(record);
		}
		return records;
	}
	
	/**
	 * 批量审核通过，目前只支持批量审核通过，不支持不通过的情况
	 * @return
	 */
	public String batCheck(){
		logger.info("manual vip batchek start..........");
		//this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");	
		UserInfo userInfo = currentUserInfo();
		try{			
			String ids[] = delseqids.split(",");
			List<ManualRechargeRecord> mrrList = new ArrayList<ManualRechargeRecord>();
			for(String id:ids){
				checkOpt(id,userInfo,mrrList);				
			}
			double totalPayMoney = 0D;
			for(ManualRechargeRecord record:mrrList){
				if(!"WAIT".equals(record.getCheckStatus())){
					throw new XLRuntimeException("用户："+record.getUserId()+",金额："+record.getMoney()+",已经审核过了，无需重复审核");
				}
				totalPayMoney += record.getMoney();
			}
			batCheckCondition(totalPayMoney);//检查是否达到返利最大额度
			updateBat(mrrList,userInfo,"PASS");
			clearList(mrrList);
		}catch(Exception e){
			logger.error("批量审核失败", e);
			mergeJsmessage("批量审核失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	private void clearList(List<ManualRechargeRecord> mrrList ){
		if(mrrList != null){
			mrrList.clear();
			mrrList = null;
		}
	}
	
	
	private void updateBat(List<ManualRechargeRecord> mrrList,UserInfo userInfo,String opt){
		for(ManualRechargeRecord record:mrrList){
			record.setCheckStatus(opt);
			record.setCheckBy(userInfo.getTrueName());
			record.setCheckTime(sdf_time.format(new Date()));
			record.setRechargeStatus("WAIT");
			FacadeFactory.INSTANCE.getBaseBo().updateObjectById(record);
			if(record.getCheckStatus().equals("PASS")){
				recharge(record.getSeqId());
			}			
		}
	}
	
	private void checkOpt(String id,UserInfo userInfo,List<ManualRechargeRecord> mrrList) throws XLRuntimeException{
		ManualRechargeRecord record = FacadeFactory.INSTANCE.getBaseBo().findById(ManualRechargeRecord.class, id);
		if(record == null) return ;
		mrrList.add(record);		
	}
	
	/**
	 * 审核
	 * @return
	 */
	public String check(){
		this.authenticateEdit();
		String idsStatus=this.findParameter("idsStatus");
		String[] isStatusArray=idsStatus.split("\\|");
		UserInfo userInfo = currentUserInfo();
		try{
			for(String idStatustemp:isStatusArray){
				String[] temps=idStatustemp.split("_");
				if(temps.length!=2){
					continue;
				}             
				ManualRechargeRecord record=FacadeFactory.INSTANCE.getBaseBo().findById(ManualRechargeRecord.class, temps[0]);
				if(record == null){
					logger.info("人工返利申请单为空");
					throw new XLRuntimeException("人工返利申请单为空");
				}
				checkCondition(record,userInfo,temps[1]);			
			}
		}catch(Exception e){
			logger.error("审核失败", e);
			mergeJsmessage("审核失败，原因：" + e.getMessage());
		}		
		return "";
	}		
	
	
	private void batCheckCondition(double totalPayMoney) throws XLRuntimeException{
		int status =  CheckGiftMoneyProxy.getInstance().checkMoney(totalPayMoney);
        if(status == 0){       	
        }else if(status == 1){
        	throw new XLRuntimeException("当日返利总金额超过最大额度");
        }else if(status == 2){
        	throw new XLRuntimeException("当月返利总金额超过最大额度");
        }else{
        	throw new XLRuntimeException("每日每月最大额度查询失败");
        }		    				
	}
	
	private void checkCondition(ManualRechargeRecord record,UserInfo userInfo,String opt) throws XLRuntimeException{
		if(!hasPermission(record.getChecker(), userInfo.getUserlogno())){
			logger.info("对不起，您没有该申请单的审核权限，只有："+record.getChecker()+" 才有权限审核");
			throw new XLRuntimeException("对不起，您没有该申请单的审核权限，只有："+record.getChecker()+" 才有权限审核");
		}
		if(!"WAIT".equals(record.getCheckStatus())){
			throw new XLRuntimeException("该订单已经审核过了，无需重复审核");
		}
		int status =  CheckGiftMoneyProxy.getInstance().checkMoney(record.getMoney().doubleValue());
        if(status == 0){
        	record.setCheckStatus(opt);
			record.setCheckBy(userInfo.getTrueName());
			record.setCheckTime(sdf_time.format(new Date()));
			record.setRechargeStatus("WAIT");
			FacadeFactory.INSTANCE.getBaseBo().updateObjectById(record);
			if(record.getCheckStatus().equals("PASS")){
				recharge(record.getSeqId());
			}			
        }else if(status == 1){
        	throw new XLRuntimeException("当日返利总金额超过最大额度");
        }else if(status == 2){
        	throw new XLRuntimeException("当月返利总金额超过最大额度");
        }else{
        	throw new XLRuntimeException("每日每月最大额度查询失败");
        }		    						
	}
	
	private boolean hasPermission(final String checkers, final String userlogno){
		String[] checkerArr = checkers.split(",");
		for(String checker : checkerArr){
			if(checker == null || checker.isEmpty()){
				continue;
			}
			if(userlogno.trim().equals(checker.trim())){
				return true;
			}
		}
		return false;
	}
	
	public void recharge(final long seqId){
		try{
			HttpClientUtil.get("http://dy.niu.xunlei.com/pay/manualRecharge.do?seqId="+seqId);
		}catch(Exception e){
			logger.error(e);
		}
	}
}
