package com.xunlei.niux.manager.web.model.vicclub;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.onesign.OneSignDaycount;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicClubCustomerService;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.server.common.exception.XLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class VicClubCustomerServiceManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(VicClubCustomerServiceManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        VicClubCustomerService bean = findBean(VicClubCustomerService.class,"vicclubcustomerservice");
        if(bean==null)bean=new VicClubCustomerService();
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);

        List<VicClubCustomerService> list = new ArrayList<VicClubCustomerService>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("seqid", OrderType.DESC);

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<VicClubCustomerService> sheet = new Sheet<VicClubCustomerService>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();
        try{
            VicClubCustomerService bean = findBean(VicClubCustomerService.class,"vicclubcustomerservice");
            checkParams();
            bean.setSeqid(null);
            FacadeFactory.INSTANCE.getBaseSo().addObject(bean);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String edit(){
        this.authenticateEdit();
        try{
            VicClubCustomerService bean = findBean(VicClubCustomerService.class,"vicclubcustomerservice");
            checkParams();
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(bean);
        }catch(Exception e){
            logger.error("操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";
    }

    private void checkParams() throws XLException {
        VicClubCustomerService bean = findBean(VicClubCustomerService.class,"vicclubcustomerservice");
        if(bean==null){
            throw new XLRuntimeException("找不到bean");
        }
        if(StringUtils.isEmpty(bean.getAbility())
                || StringUtils.isEmpty(bean.getNickName())
                || StringUtils.isEmpty(bean.getPicOne())
                || StringUtils.isEmpty(bean.getPicTwo())
                || StringUtils.isEmpty(bean.getQq())
                || StringUtils.isEmpty(bean.getUserName())
                ){
            throw new XLRuntimeException("参数异常");
        }


    }

}
