package com.xunlei.niux.manager.web.model.tourist;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.tourist.TouristGameWebActivityConfig;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-11-19
 * Time: 下午6:37
 * To change this template use File | Settings | File Templates.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_TOURISTGAMEACTIVITYCONFIG)
public class TouristGWebActConfMB extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(TouristGWebActConfMB.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;


    public TouristGWebActConfMB(){
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }


    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    /**
     * 查询抽奖奖品
     * @return
     */
    public String getQueryTouristGameWebActivityConfig(){
        logger.info("开始游客页面活动配置查询");
        String isValid = findParameter("isValid");
        this.authenticateRun();//验证运行权限
        TouristGameWebActivityConfig touristGameWebConfig = findBean(TouristGameWebActivityConfig.class, "touristgwactconfbean");

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(touristGameWebConfig);
        pagedFliper.setRecordCount(count);
        List<TouristGameWebActivityConfig> list = new ArrayList<TouristGameWebActivityConfig>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(touristGameWebConfig, page);
        }
        Sheet<TouristGameWebActivityConfig> sheet = new Sheet<TouristGameWebActivityConfig>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    /**
     * 新增游客页配置信息
     * @return
     */
    public String add(){
        logger.info("开始游客页活动配置添加");
        TouristGameWebActivityConfig touristGameWebConfig = findBean(TouristGameWebActivityConfig.class, "touristgwactconfbean");
        try{
            if(touristGameWebConfig==null){
                logger.info("游客页活动配置信息为空");
                throw new XLRuntimeException("游客页活动配置信息为空");
            }

            touristGameWebConfig.setInputBy(this.currentUserLogo());
            touristGameWebConfig.setInputTime(now());
            baseSo.addObject(touristGameWebConfig);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 删除抽奖奖品
     * @return
     */
    public String delete(){
        logger.info("开始抽奖奖品信息删除");
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids)
                baseSo.deleteById(TouristGameWebActivityConfig.class, id);
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}
