package com.xunlei.niux.manager.web.model.thread;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.SmsReceiver;
import com.xunlei.niux.data.vipgame.vo.vic.SmsSendApply;
import com.xunlei.niux.data.vipgame.vo.vic.SmsSendLog;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.manager.web.exception.NiuxException;
import com.xunlei.niux.manager.web.proxy.SmsProxy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class SmsSendApplyTask implements Runnable{

    private static final Logger logger = Logger.getLogger(SmsSendApplyTask.class.getName());

	private Long sid;

	public SmsSendApplyTask(Long sid){
		this.sid = sid;
	}

	@Override
	public void run() {
        SmsSendApply query = new SmsSendApply();
        query.setSid(sid);
        List<SmsSendApply> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for(SmsSendApply smsSendApply:list){
            if(checkPhone(smsSendApply.getPhone())){
                sms(smsSendApply);
            }
        }


	}

    private boolean checkPhone(String one_phone)
            throws XLRuntimeException
    {
        StringBuilder sql = new StringBuilder("select * from smsreceiver where sendTime>='" + getMinDay() + "' and phone in ");
        List params = new ArrayList();
        String where = "('";
        if (one_phone.indexOf(",") == -1) {
            where = where + one_phone.trim();
        } else {
            String[] phones = one_phone.split(",");
            for (String phone : phones) {
                if (!com.xunlei.util.StringTools.isEmpty(phone))
                    where = where + phone.trim() + "','";
            }
        }
        where = where + "')";
        sql.append(where);
        List<SmsReceiver> list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(SmsReceiver.class, sql.toString(), params);
        if (CollectionUtils.isNotEmpty(list)) {
            String phones = "";
            for (SmsReceiver sr : list) {
                phones = phones + sr.getPhone() + ",";
            }
            logger.error("手机号：" + phones + "，3天之内不能重复发送短信");
            return false;
        }
        return true;
    }

    private String getMinDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -3);
        return sdf.format(cal.getTime()) + " 00:00:00";
    }

    private boolean sms(SmsSendApply smsSendApply) {
        try {
            SmsProxy.getInstance().testSms(smsSendApply.getPhone(), smsSendApply.getContent());
        } catch (NiuxException e) {
            logger.error("发送短信失败,sid=" + smsSendApply.getSid() + ",phone=" + smsSendApply.getPhone(), e);
        }
        addSmsReceiver(smsSendApply);
        return true;
    }

    private void addSmsReceiver(SmsSendApply smsSendApply)
    {
        SmsReceiver receiver = new SmsReceiver();
        receiver.setContent(smsSendApply.getContent());
        receiver.setPhone(smsSendApply.getPhone());
        receiver.setSendBy(smsSendApply.getApplyPerson());
        receiver.setSendTime(DateUtil.formatNowByDefault());
        receiver.setSid(smsSendApply.getSid());
        FacadeFactory.INSTANCE.getBaseSo().addObject(receiver);

        SmsSendLog ssl = new SmsSendLog();
        ssl.setUid(smsSendApply.getUid());
        ssl.setSmsRecSid(smsSendApply.getSid());
        ssl.setTargetType(smsSendApply.getReason());
        FacadeFactory.INSTANCE.getBaseSo().addObject(ssl);
    }

}
