package com.xunlei.niux.manager.web.model.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RebateThreadPool {

	   private ThreadPoolExecutor executor;
	   private static RebateThreadPool instance = new RebateThreadPool();
	   
	   private RebateThreadPool(){
		   init();
	   }
	   
	   public static RebateThreadPool getInstance(){
		   return instance;
	   }
	   
	   
		  private void init(){
			  executor  = new ThreadPoolExecutor(10,20,20,TimeUnit.SECONDS,
					  new ArrayBlockingQueue<Runnable>(10),
					  new ThreadPoolExecutor.AbortPolicy()
					  );
			  
			  Runtime.getRuntime().addShutdownHook(new Thread(){
				   public void run(){
					   shutDown();
				   }
			  });
		  }

		  private void shutDown(){
			  executor.shutdown();
		  }
		  
		  public void execute(Runnable task){
			  executor.execute(task);
		  }
}
