package com.xunlei.niux.manager.web.model.thread;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.LinkLocation;
import com.xunlei.niux.manager.web.util.PicUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

/**
 * Created by jamesjxin on 14-5-23.
 */
public class AddMaintainFenquThread implements Runnable {
    private Advice advice;
    private LinkInfo linkInfo;
    private String fenquNums;


    public AddMaintainFenquThread(Advice advice, LinkInfo linkInfo, String fenquNums) {
        this.advice = advice;
        this.linkInfo = linkInfo;
        this.fenquNums = fenquNums;
    }

    @Override
    public void run() {
        if(StringUtils.isEmpty(fenquNums)){
            return;
        }

        LinkLocation loc= FacadeFactory.INSTANCE.getLinkLocationBo().find(linkInfo.getLinklocid());
        for(String fenqu : fenquNums.split("\\|")){
            if(StringUtils.isEmpty(fenqu)){
                continue;
            }
            LinkInfo newlinkInfo = new LinkInfo();
            BeanUtils.copyProperties(linkInfo,newlinkInfo);
            newlinkInfo.setExt1(fenqu);
            newlinkInfo.setGameid(advice.getGameId());
            newlinkInfo.setLinktitle(advice.getTitle());
            newlinkInfo.setLinkurl(advice.getContenturl());
            newlinkInfo.setInputby(advice.getInputBy());
            newlinkInfo.setInputtime(advice.getInputTime());
            newlinkInfo.setLinklocgroupid(loc.getLinktype());

            FacadeFactory.INSTANCE.getLinkInfoBo().add(newlinkInfo);
        }

    }
}
