package com.xunlei.niux.manager.web.model.tasks;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskDutyConfig;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-6-17.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_TASKCENTERCONF)
public class TaskDutyConfigManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(TaskDutyConfigManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;


    public TaskDutyConfigManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQueryTaskDutyConfigList(){
        this.authenticateRun();//验证运行权限
        TaskDutyConfig taskDutyConfig = findBean(TaskDutyConfig.class, "taskdutyconfig");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(taskDutyConfig);
        pagedFliper.setRecordCount(count);
        List<TaskDutyConfig> list = new ArrayList<TaskDutyConfig>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(taskDutyConfig, page);
        }
        Sheet<TaskDutyConfig> sheet = new Sheet<TaskDutyConfig>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        TaskDutyConfig taskDutyConfig = findBean(TaskDutyConfig.class, "taskdutyconfig");
        try{
            if(taskDutyConfig==null){
                logger.info("抽奖活动信息为空");
                throw new XLRuntimeException("抽奖活动信息为空");
            }
            taskDutyConfig.setInputBy(this.currentUserLogo());
            taskDutyConfig.setInputTime(now());
            baseSo.addObject(taskDutyConfig);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 修改抽奖活动
     * @return
     */
    public String edit(){
        this.authenticateEdit();//编辑权限
        TaskDutyConfig taskDutyConfig = findBean(TaskDutyConfig.class, "taskdutyconfig");
        try{
            if(taskDutyConfig==null){
                logger.info("抽奖活动信息为空");
                throw new XLRuntimeException("抽奖活动信息为空");
            }
            taskDutyConfig.setEditBy(this.currentUserLogo());
            taskDutyConfig.setEditTime(now());
            baseSo.updateObjectById(taskDutyConfig);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 删除抽奖活动
     * @return
     */
    public String delete(){
        logger.info("开始抽奖活动信息删除");
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        if(StringUtils.isEmpty(delseqids)){
            return "";
        }
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids)
                baseSo.deleteById(TaskDutyConfig.class, id);
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}
