package com.xunlei.niux.manager.web.model.tasks;


import com.xunlei.util.Log;
import org.slf4j.Logger;

import java.util.concurrent.*;

public class ConcurrentExecutor {

    private static Logger logger = Log.getLogger(ConcurrentExecutor.class);
    private static final ConcurrentExecutor instance = new ConcurrentExecutor();
    private ExecutorService executor;

    public static ConcurrentExecutor getInstance(){
        return instance;
    }

    private ConcurrentExecutor(){
        executor = new ThreadPoolExecutor(5, 10, 10, TimeUnit.SECONDS,
                new ArrayBlockingQueue<Runnable>(500000),
                new ThreadPoolExecutor.DiscardOldestPolicy());
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override
            public void run() {
                logger.info("ConcurrentExecutor().destroy()");
                ConcurrentExecutor.getInstance().destroy();
                logger.info("ConcurrentExecutor.getInstance().destroy()");
            }

        });
    }

    public void execute(Callable task) {
        try {
            executor.submit(task);
        } catch (Exception e) {
            logger.info("ConcurrentExecutor 添加任务异常", e);
        }
    }


    public void destroy() {
        executor.shutdown();
    }


}
