package com.xunlei.niux.manager.web.model.spreadinfoaudit;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.manager.web.client.SpreadInfoAuditClient;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.vo.spreadinfoaudit.UserInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * Created by jamesjxin on 14-7-8.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_AUDITUSERINFO)
public class UserInfoManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(UserInfoManagedBean.class.getName());

    public String getQueryAuditUserInfoList() {
        String valid = this.findParameter("valid");
        if(StringUtils.isEmpty(valid)){
            valid="";
        }

        List<UserInfo> userInfoList = SpreadInfoAuditClient.getListUsers(valid);

        if (userInfoList == null) {
            throw new XLRuntimeException("查询的用户信息为null");
        }

        PagedFliper pagedFliper = this.getFliper();
        int count = userInfoList.size();
        pagedFliper.setRecordCount(count);
        Sheet<UserInfo> sheet = new Sheet<UserInfo>(count, userInfoList);
        this.mergePagedDataModel(sheet, pagedFliper);

        return "";
    }



    public String auditTrue() {
        UserInfo userInfo = findBean(UserInfo.class, "audituserinfo");
        if (userInfo == null) {
            throw new XLRuntimeException("审核信息为空！");
        }

        boolean successAudit =  SpreadInfoAuditClient.auditUser(userInfo.getUserId().toString(),"true");
        if(!successAudit){
            throw new XLRuntimeException("审核失败！");
        }

        return "";
    }

    public String auditFalse() {
        UserInfo userInfo = findBean(UserInfo.class, "audituserinfo");
        if (userInfo == null) {
            throw new XLRuntimeException("审核信息为空！");
        }

        boolean successAudit =  SpreadInfoAuditClient.auditUser(userInfo.getUserId().toString(),"false");
        if(!successAudit){
            throw new XLRuntimeException("审核失败！");
        }

        return "";
    }
}
