package com.xunlei.niux.manager.web.model.report;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CheatingReport;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.BlackWhiteInfoManagedBean;
import com.xunlei.niux.manager.web.model.CustomersManagedBean;
import com.xunlei.niux.manager.web.model.vo.BlackWhiteInfo;
import com.xunlei.niux.manager.web.model.vo.CustomerServers;
import com.xunlei.niux.manager.web.proxy.JRedisProxy;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.server.common.exception.XLException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


/**
 * 举报外挂
 */
public class CheatingReporManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CheatingReporManagedBean.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private BaseSo baseSo;
    private static final String WEBSVR="http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo?type=200";

	public CheatingReporManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
	}

	public String getCheatingReportList(){
        this.authenticateRun();//验证运行权限
        CheatingReport cr = findBean(CheatingReport.class,"cheatingreportvo");
        if(cr==null)cr = new CheatingReport();
        logger.info("[getCheatingReportList]gameid:"+ cr.getCheaterGameId()+", serverid:"+cr.getCheaterServerId());
//        try {
//            System.out.println(BeanUtils.describe(cr));
//        } catch (IllegalAccessException e) {
//            e.printStackTrace();
//        } catch (InvocationTargetException e) {
//            e.printStackTrace();
//        } catch (NoSuchMethodException e) {
//            e.printStackTrace();
//        }
        if(cr.getStatus()!=null&&cr.getStatus()==0){
            cr.setStatus(null);
        }

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(cr);
        logger.info("[getCheatingReportList]count:"+count);
        pagedFliper.setRecordCount(count);

        List<CheatingReport> list = new ArrayList<CheatingReport>();
        if (count > 0) {
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("reportTime", OrderType.DESC);

        	list = baseSo.findObjects(cr, page);
            logger.info("[getCheatingReportList]result list size:"+(list != null ? list.size() : 0));
            for(int i=0,len=list.size();i<len;i++){
                CheatingReport cheatingReport = list.get(i);
                Long lockSec = cheatingReport.getLockSeconds();
                if(lockSec==-1){
                    cheatingReport.setLockSecondsDisplay("");
                }else if(lockSec==0){
                    cheatingReport.setLockSecondsDisplay("永久");
                }else if(lockSec>0){
                    long lockDay= lockSec/86400;
                    String lockTimeStr;
                    if(lockDay<1){
                        lockTimeStr = lockSec+"秒";
                    }else{
                        lockTimeStr = lockDay+"天";
                    }
                    cheatingReport.setLockSecondsDisplay(lockTimeStr);
                }else{
                    cheatingReport.setLockSecondsDisplay(lockSec+"");
                }
                list.set(i,cheatingReport);
            }
        }
        Sheet<CheatingReport> sheet = new Sheet<CheatingReport>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}


	public String handling(){
		this.authenticateRun();//验证运行权限
		//更新修改人
		UserInfo user=this.currentUserInfo();
		String audittime = sdf.format(new Date());

        Long seqid = findParamLong("one_seqid");
        String handleDesc = findParameter("one_handleDesc");
        Integer status = findParamInt("cheatingreport_status");
        String customerId = findParameter("one_cheaterCustomerId");
        if(StringUtils.isEmpty(customerId)){
            mergeJsmessage("请输入封禁账号！");
            return "";
        }

        Long lockSeconds = -1L;

        if(status==2){
            String tmp =findParameter("cheatingreport_lockseconds");
            if(StringUtils.isEmpty(tmp)){
                mergeJsmessage("请选择封禁时间！");
                return "";
            }
            lockSeconds = Long.valueOf(tmp);
        }

//System.out.println("one_seqid="+seqid+", one_handledesc="+handleDesc+", cheatingreport_status="+status+", cheatingreport_lockseconds="+lockSeconds);

		try{
            CheatingReport report = baseSo.findById(CheatingReport.class, seqid);
            if(report == null){
                mergeJsmessage("数据异常，找不到该条举报数据");
                return "";
            }
            report.setCheaterCustomerId(customerId);
            report.setHandler(user.getTrueName());
            report.setHandleTime(audittime);
            report.setHandleDesc(StringUtils.isNotEmpty(handleDesc) ? handleDesc : "");
            report.setLockSeconds(lockSeconds);
            report.setStatus(status);

            String logBean = BeanUtils.describe(report).toString();
            logger.info("[CHEATING REPORT]handling user:"+logBean);

            if(status==2){//封禁
                String dbname = getdbname(report.getCheaterGameId());

                BlackWhiteInfo black = new BlackWhiteInfo();
                black.setLogininfo(getUid(report.getCheaterGameId(), customerId));
                black.setReason(report.getHandleDesc());
                black.setType("0");
                black.setEditor(user.getTrueName());
                black.setEdittime(String.valueOf(new Date().getTime() / 1000));
                black.setOverduedate(getFreeDate(lockSeconds));
                addBlackinfo(black, dbname);

                updateCache(report.getCheaterGameId(),black);
            }
            baseSo.updateObjectById(report);
        }catch(Exception e){
            logger.error("[CHEATING REPORT]update failed", e);
            mergeJsmessage("[CHEATING REPORT]操作失败,原因:" + e.getMessage());
        }
        return "";

    }

    /**
     * 拿到账号信息
     */
    private String getUid(String gameid, String customerId) throws Exception {
        String url = WEBSVR+"&gameid="+gameid+"&accounts="+customerId;
        String resp = HttpClientUtil.get(url);

        JSONObject json = new JSONObject(resp);
        String uid = json.getString("result").split("=")[1];
        if("null".equals(uid)){
            logger.info("[CHEATING REPORT]getUid is NULL!!!  gameid="+gameid+", customerId="+customerId+", resp="+resp);
            throw new XLException("未查询到被举报玩家[" + customerId + "]的账号，不能封号，请联系管理员处理。");
        }
        return uid;
    }

    private String getFreeDate(Long lockSeconds) {
        if(lockSeconds==0){
            lockSeconds=3153600000L;
        }
        long cur = System.currentTimeMillis()+(lockSeconds*1000);
        return sdf.format(new Date(cur));
    }

    /**
     * 更新缓存
     */
    private void updateCache(String gameId, BlackWhiteInfo black) {
        String gameBlackKey = gameId + "_" + black.getLogininfo() + "_" + black.getType()+ "_black";
        Calendar calendar = Calendar.getInstance();
        int minute = calendar.get(Calendar.MINUTE);
        boolean catchresult = JRedisProxy.getInstance().set(gameBlackKey, black.getOverduedate(), (60-minute)*60);
        logger.info(" add blackwhiteinfo.end refresh cache.插入成功结果存数缓存"+ ",gameid:" + gameId + ",gameBlackKey:"+gameBlackKey+ ",catchresult:"+catchresult+",balckwhite:"+black);
    }


    /**
     * 添加黑名单（封号）
     */
    private void addBlackinfo(BlackWhiteInfo black, String dbname) throws Exception{
        BlackWhiteInfo query = new BlackWhiteInfo();
        query.setLogininfo(black.getLogininfo());
        query.setType("0");
        List<BlackWhiteInfo> hasBlack =  BlackWhiteInfoManagedBean.getBlackWhiteInfos(query, dbname, 1, 1, 1);
        if(hasBlack==null || hasBlack.isEmpty()){
            List<BlackWhiteInfo> newBlackList = new ArrayList<BlackWhiteInfo>();
            newBlackList.add(black);
            BlackWhiteInfoManagedBean.addBlackWhiteInfo(newBlackList, dbname, 1);//添加账号黑名单type ==1
        }else {
            BlackWhiteInfo blackWhiteInfo = hasBlack.get(0);
            blackWhiteInfo.setOverduedate(black.getOverduedate());
            blackWhiteInfo.setEdittime(black.getEdittime());
            blackWhiteInfo.setReason(black.getReason());
            blackWhiteInfo.setEditor(black.getEditor());
            BlackWhiteInfoManagedBean.updateBlackWhiteInfo(blackWhiteInfo, dbname, 1);
        }
    }


    /**
     * 拿到对应数据库
     */
    private String getdbname(String gameId) throws Exception{
        String dbname = BlackWhiteInfoManagedBean.getDBName(gameId);
        logger.info("[CHEATING REPORT]getdbname:"+dbname);
        if(StringUtils.isEmpty(dbname)){
            logger.error("[CHEATING REPORT]get NULL dbname:" + dbname + ",gameid:" + gameId);
            throw new XLException("未查询到被举报玩家的游戏[" + gameId + "]，不能封号，请联系管理员处理。");
        }
        return dbname;
    }

}
