package com.xunlei.niux.manager.web.model.onesign;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.customer.AutomaticServiceBug;
import com.xunlei.niux.data.vipgame.vo.onesign.OneSignDaycount;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class OneSignDayCountManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(OneSignDayCountManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        OneSignDaycount bean = findBean(OneSignDaycount.class,"onesigndaycount");
        if(bean==null)bean=new OneSignDaycount();
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);

        List<OneSignDaycount> list = new ArrayList<OneSignDaycount>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("signDate", OrderType.DESC);

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<OneSignDaycount> sheet = new Sheet<OneSignDaycount>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


}
