package com.xunlei.niux.manager.web.model.mobileapk.auditthread;

import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.easyutils.commonutils.MapEasyUtils;
import com.xunlei.niux.manager.template.builder.fenqu.FenQuBuilder;
import com.xunlei.niux.manager.template.constant.TemplateIdConstant;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-28.
 */
public class AddGameServerThread implements Callable{

    private Games game;
    private UserInfo userInfo;

    public AddGameServerThread(Games game, UserInfo userInfo) {

        this.game = game;
        this.userInfo = userInfo;
    }

    @Override
    public Map<String,Object> call() throws Exception {
        String msg = "";
        try {
            GameServers gameServer = findFirstGameServerByGameId(game.getGameId());
            if(gameServer != null){
                return MapEasyUtils.generateMap(0, "区服信息已存在！");
            }

            String nowStr = DateUtil.formatNowByDefault();
            gameServer = new GameServers();
            gameServer.setGameId(game.getGameId());
            gameServer.setFenQuNum(1);
            gameServer.setFenQuName("1区");
            gameServer.setServerId("1");
            gameServer.setServerName("1区");
            gameServer.setAddress("http://");
            gameServer.setOpenStatus("1");//已接入
            gameServer.setOpenTime(nowStr);

            gameServer.setInputBy(userInfo.getTrueName());
            gameServer.setInputTime(nowStr);
            gameServer.setRemark("");

            gameServer.setRedtitle(false);
            gameServer.setIsnew(false);
            gameServer.setIsrecommand(false);


            FacadeFactory.INSTANCE.getBaseSo().addObject(gameServer);

            addEnterGameTemplateSchema(gameServer.getGameId());
            noticeniuxupdatecache(gameServer.getGameId());
            //注释同步脚本
            Runtime.getRuntime().exec("/usr/local/htdocs/JNetPayGenXml/startup.sh");

        } catch (Exception e) {
            return MapEasyUtils.generateMap(-1,e.getMessage());
        }

        return MapEasyUtils.generateMap(0,"成功");
    }

    private GameServers findFirstGameServerByGameId(String gameId){
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setFenQuNum(1);
        GameServers gameServer = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        return gameServer;
    }

    private void noticeniuxupdatecache(String gameId){
        try{
            //通知模板更新
            HtmlTemplate ht=new HtmlTemplate();
            ht.setTemplateid(TemplateIdConstant.TEMPLATE_GAME_FENQU);
            ht.setExt1(gameId);
            FenQuBuilder fqb=new FenQuBuilder();
            fqb.addTeamplateSchema(ht, false);
            //FenQuBuilder
        }catch(Exception e){
            throw new RuntimeException("通知失败",e);
        }
    }

    private void addEnterGameTemplateSchema(String gameId){
        String nowStr=DateUtil.formatNowByDefault();
        //添加执行计划
        TemplateSchema ts=new TemplateSchema();
        ts.setTemplateid("000027");
        ts.setSchematime(nowStr);
        ts.setIsexecuted(false);
        ts.setInputby("系统");
        ts.setInputtime(nowStr);
        ts.setIspreview(false);
        ts.setExt1(gameId);
        FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
    }
}
