package com.xunlei.niux.manager.web.model.mobileapk.auditthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.DbConfig;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.easyutils.commonutils.KeyGenerateUtil;
import com.xunlei.niux.easyutils.commonutils.MapEasyUtils;
import com.xunlei.niux.manager.web.model.GameXmlMetaManagedBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-28.
 */
public class AddGameDatabaseAndLoginConfigThread implements Callable{
    private static final Logger logger = Logger.getLogger(AddGameDatabaseAndLoginConfigThread.class.getName());

    private Games game;

    public AddGameDatabaseAndLoginConfigThread(Games game) {
        this.game = game;
    }

    @Override
    public Map<String,Object> call() throws Exception {
        GameXmlMeta gameXmlMeta = null;
        try {
            DbConfig dbConfig = addDbConfig(game);

            gameXmlMeta = AddGameXmlData(game,dbConfig);
        } catch (Exception e) {
            logger.error("AddGameDatabaseAndLoginConfigThread Exception:",e);
            return MapEasyUtils.generateMap(-1, e.getMessage());
        }
        return MapEasyUtils.generateMap(0,gameXmlMeta);
    }

    private DbConfig addDbConfig(Games game){
        String oldgameId = game.getGameId().substring(1);
        DbConfig dbConfig = findDbConfigByGameId(oldgameId);
        if(dbConfig != null){
            return dbConfig;
        }

        dbConfig = new DbConfig();
        dbConfig.setGameid(oldgameId);
        dbConfig.setGamename(game.getGameName());
        dbConfig.setDbname(getNewDBName());
        dbConfig.setDsname("1");
        IFacade.INSTANCE.saveDbConfig(dbConfig);
        return dbConfig;
    }

    private String getNewDBName(){
        String result = "";
//        Page page = new Page();
//        page.addOrder("dbname", OrderType.DESC);
//        page.setPageNo(1);
//        page.setPageSize(1);

        PagedFliper fliper = new PagedFliper();
        fliper.setSortColumn(" dbname desc");
        fliper.setPageNo(1);
        fliper.setPageSize(1);
        List<DbConfig> dbConfigList = (List<DbConfig>)IFacade.INSTANCE.queryDbConfig(new DbConfig(),fliper).getDatas();
        if(CollectionUtils.isNotEmpty(dbConfigList)){
            String dbName = dbConfigList.get(0).getDbname();
            String db_Prefix = dbName.substring(0,8);
            int db_num = Integer.parseInt(dbName.substring(8)) + 1;
            String db_numStr = String.valueOf(db_num);
            int strLenth = db_numStr.length();
            for(int i = 0; i< 6-strLenth;i++){
                db_numStr = "0"+db_numStr;
            }
            result = db_Prefix+db_numStr;
        }
        return result;
    }

    private DbConfig findDbConfigByGameId(String gameId){
        DbConfig query = new DbConfig();
        query.setGameid(gameId);
        DbConfig dbConfig = IFacade.INSTANCE.getBoFactory().getDbconfigBo().findDbConfig(query);
        return dbConfig;
    }

    private GameXmlMeta AddGameXmlData(Games game,DbConfig dbConfig){
        GameXmlMeta gameXmlMeta = null;
        try {
            String oldGameId = game.getGameId().substring(1);
            gameXmlMeta = findGameXmlMetaByGameId(oldGameId);
            if(gameXmlMeta != null){
                return gameXmlMeta;
            }

            gameXmlMeta = new GameXmlMeta();
            gameXmlMeta.setGameid(oldGameId);
            gameXmlMeta.setSimpleName(game.getSimpleName());
            gameXmlMeta.setDatabaseName(dbConfig.getDbname());
            gameXmlMeta.setFilePath("/usr/local/ly_gameservers/ly_authserver/games/");
            gameXmlMeta.setPublicKey(KeyGenerateUtil.generateLoginPublicPrivateKey());
            gameXmlMeta.setPrivateKey(KeyGenerateUtil.generateLoginPublicPrivateKey());
            gameXmlMeta.setLoginKey(KeyGenerateUtil.generateKeyByLength(32));

            gameXmlMeta.setCheckRegisterTimeFlag(false);
            gameXmlMeta.setAdultCheckFlag(false);
            gameXmlMeta.setDefaultQuery(true);
            gameXmlMeta.setOpenQueryRoleName(true);
            gameXmlMeta.setIsWeiDuan(false);

            gameXmlMeta.setIsLevelInterface(false);
            gameXmlMeta.setIsOnlineInterface(false);
            gameXmlMeta.setIsRank(false);

            gameXmlMeta.setRoleurl("");
            gameXmlMeta.setRolekey("");

            gameXmlMeta.setOnlineurl("");
            gameXmlMeta.setOnlinekey("");

            gameXmlMeta.setRankurl("");
            gameXmlMeta.setRankkey("");


            GameXmlMetaManagedBean gameXmlMetaManagedBean = new GameXmlMetaManagedBean();
            //注释同步脚本
            gameXmlMetaManagedBean.location();//拉回

            Thread.sleep(3000);

            gameXmlMetaManagedBean.backup();//备份
            gameXmlMetaManagedBean.addGameXmlMeta(gameXmlMeta,false,"系统");//true，同步
        } catch (Exception e) {
            logger.error("AddGameXmlData Exception:",e);
            throw new XLRuntimeException("AddGameXmlData Exception:", e);
        }

        return gameXmlMeta;
    }

    private GameXmlMeta findGameXmlMetaByGameId(String gameId){
        GameXmlMeta query = new GameXmlMeta();
        query.setGameid(gameId);
        List<GameXmlMeta> gameXmlMetaList = FacadeFactory.INSTANCE.getGameXmlMetaBo().find(query,new Page());
        if(CollectionUtils.isNotEmpty(gameXmlMetaList)){
            return gameXmlMetaList.get(0);
        }
        return null;
    }

    public static void main(String[] args){
//        String dbName = "xlyouxi_000207";
//        String db_Prefix = dbName.substring(0,8);
//        int db_num = Integer.parseInt(dbName.substring(8)) + 1;
//        String db_numStr = String.valueOf(db_num);
//        int strLenth = db_numStr.length();
//        for(int i = 0; i< 6-strLenth;i++){
//            db_numStr = "0"+db_numStr;
//        }
//
//        System.out.println(db_Prefix+db_numStr);
        DbConfig dbConfig = new DbConfig();
        System.out.println(dbConfig);

    }


}
