package com.xunlei.niux.manager.web.model.mobileapk;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.auditplatform.bo.BaseSo;
import com.xunlei.niux.data.auditplatform.facade.FacadeFactory;
import com.xunlei.niux.data.auditplatform.vo.BusinessInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-7-31.
 */
@FunRef("auditbusinessinfo")
public class AuditBusinessInfoManagedBean extends BaseManagedBean{
    private static final Logger logger = Logger.getLogger(AuditBusinessInfoManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

    public AuditBusinessInfoManagedBean() {
        this.baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQueryBusinessInfoList(){
        this.authenticateRun();//验证运行权限
        BusinessInfo businessInfo = findBean(BusinessInfo.class, "auditbusinessinfo");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(businessInfo);
        pagedFliper.setRecordCount(count);
        List<BusinessInfo> list = new ArrayList<BusinessInfo>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(businessInfo, page);
        }
        Sheet<BusinessInfo> sheet = new Sheet<BusinessInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        BusinessInfo businessInfo = findBean(BusinessInfo.class, "auditbusinessinfo");
        try{
            if(businessInfo==null){
                logger.info("抽奖活动信息为空");
                throw new XLRuntimeException("抽奖活动信息为空");
            }
            businessInfo.setInputBy(this.currentUserLogo());
            businessInfo.setInputTime(now());
            baseSo.addObject(businessInfo);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 修改抽奖活动
     * @return
     */
    public String edit(){
        this.authenticateEdit();//编辑权限
        BusinessInfo businessInfo = findBean(BusinessInfo.class, "auditbusinessinfo");
        try{
            if(businessInfo==null){
                logger.info("抽奖活动信息为空");
                throw new XLRuntimeException("抽奖活动信息为空");
            }
            businessInfo.setEditBy(this.currentUserLogo());
            businessInfo.setEditTime(now());
            baseSo.updateObjectById(businessInfo);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 删除抽奖活动
     * @return
     */
    public String delete(){
        logger.info("开始抽奖活动信息删除");
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        if(StringUtils.isEmpty(delseqids)){
            return "";
        }
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids)
                baseSo.deleteById(BusinessInfo.class, id);
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}
