package com.xunlei.niux.manager.web.model.lychat;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.lychat.facade.FacadeFactory;
import com.xunlei.niux.data.lychat.vo.*;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.cache.LyChatCache;
import com.xunlei.niux.manager.web.model.tasks.ConcurrentExecutor;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.vo.NiuxEmailVo;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.*;

public class LyChatWarningService {
    private static final Logger logger = Logger.getLogger(LyChatWarningService.class.getName());
    private static final String xlniuxlychatsvr =  EnvPropertyUtil.loadProperty("niux", "xlniuxlychatsvr");
    private static final Map<String, LyChatGameVO> gameMap = new HashMap<String, LyChatGameVO>();
    private static LyChatWarningService lyChatWarningService = new LyChatWarningService();
//    private static final String[] addrs = {"liangdong@xunlei.com","yinqiang1@xunlei.com","linying@xunlei.com"};

    public static LyChatWarningService getInstance() {
        if(lyChatWarningService==null){
            lyChatWarningService = new LyChatWarningService();
        }
        return lyChatWarningService;
    }



    public void tranData() throws Exception{
        logger.info("START lychat warning data transaction....");
        gameMap.clear();
        LyChatGameVO lcg = new LyChatGameVO();
        lcg.setIsWorking(1);
        List<LyChatGameVO> gameList = FacadeFactory.INSTANCE.getBaseSo().findObjects(lcg, new Page());
        for(LyChatGameVO game: gameList){
            gameMap.put(game.getGameId(),game);
        }

        List<LychatWarningRecordVO> repeatList = getRepeatData();
        List<LychatWarningRecordVO> senList = getSensitiveData();
        cleanLychatWarningRecord();

        tranRepeatData(repeatList);
        tranSensitiveData(senList);
        logger.info("END lychat warning data transaction##############");
    }

    private void tranSensitiveData(List<LychatWarningRecordVO> senList) throws Exception{
        Set<String> cusIdSet= new HashSet<String>();
        //先保存到数据库
        for(LychatWarningRecordVO lwr:senList){
            LyChatWarningSensitiveVO lyChatWarningSensitiveVO = new LyChatWarningSensitiveVO();
            lyChatWarningSensitiveVO.setGameId(lwr.getGameId());
            lyChatWarningSensitiveVO.setServerId(lwr.getServerId());
            String customerId = lwr.getCustomerId();
            lyChatWarningSensitiveVO.setCustomerId(customerId);
            lyChatWarningSensitiveVO.setRoleId(lwr.getRoleId());
            lyChatWarningSensitiveVO.setRoleLevel(lwr.getRoleLevel());
            lyChatWarningSensitiveVO.setRoleName(lwr.getRoleName());
            lyChatWarningSensitiveVO.setChatTime(lwr.getChatTime());
            lyChatWarningSensitiveVO.setChatIp(lwr.getChatIp());
            lyChatWarningSensitiveVO.setChatContent(lwr.getChatContent());
            lyChatWarningSensitiveVO.setChatContentStyle(lwr.getChatContentStyle());
            lyChatWarningSensitiveVO.setChatChannel(lwr.getChatChannel());
            lyChatWarningSensitiveVO.setNumOfSen(Integer.valueOf(lwr.getWarnType().split("_")[1]));
            FacadeFactory.INSTANCE.getBaseSo().addObject(lyChatWarningSensitiveVO);
            if(!cusIdSet.contains(customerId)){
                cusIdSet.add(customerId);
            }
        }

        //从数据库中统计结果
        Map<LyChatWarningSensitiveVO,Integer> cusToNumMap = FacadeFactory.INSTANCE.getLyChatBo().getNumOfSensitiveWarning(cusIdSet);

        for(Map.Entry<LyChatWarningSensitiveVO, Integer> cusToNum : cusToNumMap.entrySet()){
            LyChatGameVO game = gameMap.get(cusToNum.getKey().getGameId());
            if (game == null || game.getIsWorking() != 1) {
                continue;
            }
//set not auto
game.setAutoPunish(0);
            String time = com.xunlei.niux.manager.web.util.DateUtil.formatNowByDefault();
            if(game.getAutoPunish()==1){
                int numOfSen = cusToNum.getValue();
                String warnDesc = "匹配敏感词"+numOfSen+"次";
                String opId = "0";
                if(numOfSen==1){//禁言30分钟
                    opId = "1111800";
                }else if(numOfSen==2){//封号1天
                    opId = "12186400";
                }else if(numOfSen>=3){//永久封号
                    opId = "1210";
                }


                LyChatOperationVO queryLco = new LyChatOperationVO();
                queryLco.setOpId(opId);
                LyChatOperationVO lyChatOperationVO = FacadeFactory.INSTANCE.getBaseSo().findObject(queryLco);
                String opDesc = lyChatOperationVO.getDescription();

                StringBuilder urlSb = new StringBuilder();
                urlSb.append(xlniuxlychatsvr).append("/lychat/punish.do?")
                        .append("action=").append(opId)
                        .append("&gameid=").append(cusToNum.getKey().getGameId())
                        .append("&serverid=").append(cusToNum.getKey().getServerId())
                        .append("&customerid=").append(cusToNum.getKey().getCustomerId());
                logger.info("punishRepeat send:" + urlSb.toString());
                String resp = HttpClientUtil.get(urlSb.toString());
                logger.info("punishRepeat return:"+resp);

                long detailId = saveDetail(cusToNum.getKey());

                LyChatWarningVO lcw = new LyChatWarningVO();
                lcw.setDetailId(detailId);
                lcw.setHappenTime(time);
                if("0".equals(resp)){
                    lcw.setStatus(0);
                    lcw.setFinishTime(time);
                }else {
                    lcw.setStatus(1);
                }
                FacadeFactory.INSTANCE.getBaseSo().addObject(lcw);

                LyChatOperationLogVO lco = new LyChatOperationLogVO();
                lco.setDetailId(detailId);
                lco.setOpId(opId);
                lco.setDescription("");
                lco.setOperator("系统");
                lco.setWorkTime(time);
                lco.setIsSuccess("0".equals(resp)?1:0);
                lco.setErrorMsg(resp);
                FacadeFactory.INSTANCE.getBaseSo().addObject(lco);

                NiuxEmailVo email = new NiuxEmailVo();
                String gameName = GameCache.getInstance().getGameIdNameMap().get(cusToNum.getKey().getGameId());
                gameName = StringTools.isEmpty(gameName)?cusToNum.getKey().getGameId():gameName;
                email.setSubject(String.format("聊天监控：%s[%d]区[%s]已自动处理：%s", gameName, cusToNum.getKey().getServerId(), cusToNum.getKey().getRoleName(),opDesc));
                email.setContent("聊天内容：" + cusToNum.getKey().getChatContent()+", "+warnDesc);
                email.setAddrs(LyChatCache.getInstance().getLyChatGameMap().get(cusToNum.getKey().getGameId()).getAddr().split(","));
                sendMail(email);
            }else{
                int numOfSen = cusToNum.getValue();
                String warnDesc = "匹配敏感词"+numOfSen+"次";
                long detailId = saveDetail(cusToNum.getKey());
                LyChatWarningVO lcw = new LyChatWarningVO();
                lcw.setDetailId(detailId);
                lcw.setStatus(1);
                lcw.setHappenTime(time);
                FacadeFactory.INSTANCE.getBaseSo().addObject(lcw);
                NiuxEmailVo email = new NiuxEmailVo();
                String gameName = GameCache.getInstance().getGameIdNameMap().get(cusToNum.getKey().getGameId());
                gameName = StringTools.isEmpty(gameName)?cusToNum.getKey().getGameId():gameName;
                email.setSubject(String.format("聊天监控：%s[%d]区[%s]疑似拉人，请及时处理", gameName, cusToNum.getKey().getServerId(), cusToNum.getKey().getRoleName()));
                email.setContent("聊天内容：" + cusToNum.getKey().getChatContent()+", "+warnDesc);
                email.setAddrs(LyChatCache.getInstance().getLyChatGameMap().get(cusToNum.getKey().getGameId()).getAddr().split(","));
                sendMail(email);
            }
        }


    }

    private void tranRepeatData(List<LychatWarningRecordVO> repeatList) throws Exception{
        for(LychatWarningRecordVO lwr : repeatList) {

            LyChatGameVO game = gameMap.get(lwr.getGameId());
            if (game == null || game.getIsWorking() != 1) {
                continue;
            }
//set not auto
game.setAutoPunish(0);
            String time = com.xunlei.niux.manager.web.util.DateUtil.formatNowByDefault();
            if (game.getAutoPunish() == 1) {
                String warnType = lwr.getWarnType();
                String warnDesc = "-1";
                String opId = "0";
                if("3".equals(warnType)){//禁言30分钟
                    opId = "1111800";
                    warnDesc = "发布重复信息3次";
                }else if("4".equals(warnType)){//封号24小时
                    opId = "12186400";
                    warnDesc = "连续发布重复信息5次";
                }
                LyChatOperationVO queryLco = new LyChatOperationVO();
                queryLco.setOpId(opId);
                LyChatOperationVO lyChatOperationVO = FacadeFactory.INSTANCE.getBaseSo().findObject(queryLco);
                String opDesc = lyChatOperationVO.getDescription();

                StringBuilder urlSb = new StringBuilder();
                urlSb.append(xlniuxlychatsvr).append("/lychat/punish.do?")
                        .append("action=").append(opId)
                        .append("&gameid=").append(lwr.getGameId())
                        .append("&serverid=").append(lwr.getServerId())
                        .append("&customerid=").append(lwr.getCustomerId());
                logger.info("punishRepeat send:" + urlSb.toString());
                String resp = HttpClientUtil.get(urlSb.toString());
                logger.info("punishRepeat return:"+resp);

                long detailId = saveDetail(lwr);

                LyChatWarningVO lcw = new LyChatWarningVO();
                lcw.setDetailId(detailId);
                lcw.setHappenTime(time);
                if("0".equals(resp)){
                    lcw.setStatus(0);
                    lcw.setFinishTime(time);
                }else {
                    lcw.setStatus(1);
                }
                FacadeFactory.INSTANCE.getBaseSo().addObject(lcw);

                LyChatOperationLogVO lco = new LyChatOperationLogVO();
                lco.setDetailId(detailId);
                lco.setOpId(opId);
                lco.setDescription("");
                lco.setOperator("系统");
                lco.setWorkTime(time);
                lco.setIsSuccess("0".equals(resp)?1:0);
                lco.setErrorMsg(resp);
                FacadeFactory.INSTANCE.getBaseSo().addObject(lco);

                NiuxEmailVo email = new NiuxEmailVo();
                String gameName = GameCache.getInstance().getGameIdNameMap().get(lwr.getGameId());
                gameName = StringTools.isEmpty(gameName)?lwr.getGameId():gameName;
                email.setSubject(String.format("聊天监控：%s[%d]区[%s]已自动处理：%s", gameName, lwr.getServerId(), lwr.getRoleName(),opDesc));
                email.setContent("聊天内容：" + lwr.getChatContent()+", "+warnDesc);
                email.setAddrs(LyChatCache.getInstance().getLyChatGameMap().get(lwr.getGameId()).getAddr().split(","));
                sendMail(email);
            } else {
                String warnType = lwr.getWarnType();
                String warnDesc = "-1";
                if("3".equals(warnType)){
                    warnDesc = "发布重复信息3次";
                }else if("4".equals(warnType)){
                    warnDesc = "连续发布重复信息5次";
                }
                long detailId = saveDetail(lwr);
                LyChatWarningVO lcw = new LyChatWarningVO();
                lcw.setDetailId(detailId);
                lcw.setStatus(1);
                lcw.setHappenTime(time);
                FacadeFactory.INSTANCE.getBaseSo().addObject(lcw);
                NiuxEmailVo email = new NiuxEmailVo();
                String gameName = GameCache.getInstance().getGameIdNameMap().get(lwr.getGameId());
                gameName = StringTools.isEmpty(gameName)?lwr.getGameId():gameName;
                email.setSubject(String.format("聊天监控：%s[%d]区[%s]疑似拉人，请及时处理", gameName, lwr.getServerId(), lwr.getRoleName()));
                email.setContent("聊天内容：" + lwr.getChatContent()+", "+warnDesc);
                email.setAddrs(LyChatCache.getInstance().getLyChatGameMap().get(lwr.getGameId()).getAddr().split(","));
                sendMail(email);
            }
        }
    }

    private void sendMail(NiuxEmailVo email) throws Exception {
        logger.info("[LyChatWarningService Send mail]"+ email.getSubject()+", "+email.getContent()+", "+Arrays.toString(email.getAddrs()));
        String[] arr = email.getAddrs();
        for(int i = 0, len = arr.length;i<len;i++){
            if(!arr[i].contains("@")){
                arr[i] = arr[i].trim()+"@cc.sandai.net";
            }
        }
        ConcurrentExecutor.getInstance().execute(new LyChatEmailSender(email));
    }

    private Long saveDetail(LychatWarningRecordVO lwr){
        LyChatDetailVO lcd = new LyChatDetailVO();
        lcd.setGameId(lwr.getGameId());
        lcd.setServerId(lwr.getServerId());
        lcd.setCustomerId(lwr.getCustomerId());
        lcd.setRoleName(lwr.getRoleName());
        lcd.setRoleId(lwr.getRoleId());
        lcd.setRoleLevel(lwr.getRoleLevel());
        lcd.setChatIp(lwr.getChatIp());
        lcd.setChatTime(lwr.getChatTime());
        lcd.setChatChannel(lwr.getChatChannel());
        lcd.setChatContent(lwr.getChatContent());
        lcd.setChatContentStyle(lwr.getChatContentStyle());
        lcd.setWarnType(Integer.valueOf(lwr.getWarnType()));
        return FacadeFactory.INSTANCE.getBaseSo().insertReturnId(lcd);
    }

    private Long saveDetail(LyChatWarningSensitiveVO lws){
        LyChatDetailVO lcd = new LyChatDetailVO();
        lcd.setGameId(lws.getGameId());
        lcd.setServerId(lws.getServerId());
        lcd.setCustomerId(lws.getCustomerId());
        lcd.setRoleName(lws.getRoleName());
        lcd.setRoleId(lws.getRoleId());
        lcd.setRoleLevel(lws.getRoleLevel());
        lcd.setChatIp(lws.getChatIp());
        lcd.setChatTime(lws.getChatTime());
        lcd.setChatChannel(lws.getChatChannel());
        lcd.setChatContent(lws.getChatContent());
        lcd.setChatContentStyle(lws.getChatContentStyle());
        lcd.setWarnType(2);
        return FacadeFactory.INSTANCE.getBaseSo().insertReturnId(lcd);
    }

    private List<LychatWarningRecordVO> getRepeatData(){
        String sql = "SELECT * FROM lychat_warning_record WHERE warnType = '3' OR warnType = '4'";
        return  FacadeFactory.INSTANCE.getBaseSo().executeQuery(LychatWarningRecordVO.class, sql, new ArrayList<Object>());
    }

    private List<LychatWarningRecordVO> getSensitiveData(){
        String sql = "SELECT * FROM lychat_warning_record WHERE warnType LIKE '2_%'";
        return  FacadeFactory.INSTANCE.getBaseSo().executeQuery(LychatWarningRecordVO.class, sql, new ArrayList<Object>());
    }

    private void cleanLychatWarningRecord(){
        String sql3 = "DELETE FROM lychat_warning_record";
        FacadeFactory.INSTANCE.getBaseSo().getBaseDao().execute(sql3, new ArrayList<Object>());
    }


}
