package com.xunlei.niux.manager.web.model.lychat;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.lychat.bo.BaseSo;
import com.xunlei.niux.data.lychat.facade.FacadeFactory;
import com.xunlei.niux.data.lychat.dto.LyChatWarningDTO;
import com.xunlei.niux.data.lychat.vo.LyChatDetailVO;
import com.xunlei.niux.data.lychat.vo.LyChatOperationLogVO;
import com.xunlei.niux.data.lychat.vo.LyChatOperationVO;
import com.xunlei.niux.data.lychat.vo.LyChatWarningVO;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class LyChatWarningManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LyChatWarningManagedBean.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String xlniuxlychatsvr =  EnvPropertyUtil.loadProperty("niux", "xlniuxlychatsvr");
    private BaseSo baseSo;
    private int rownum = 0;

    public LyChatWarningManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getLyChatWarningList(){
        this.authenticateRun();
        try{

            LyChatWarningVO query = findBean(LyChatWarningVO.class,"lychatwarning");
            if(query.getStatus()!=null&&query.getStatus().equals(-1)){
                query.setStatus(null);
            }
            System.out.println(BeanUtils.describe(query));
            PagedFliper pagedFliper = this.getFliper();
            int count = baseSo.countObject(query);
            pagedFliper.setRecordCount(count);
            List<LyChatWarningDTO> list = new ArrayList<LyChatWarningDTO>();
            if(count>0){
                rownum = 1;
                Page page=new Page();
                page.setPageNo(pagedFliper.getPageNo());
                page.setPageSize(pagedFliper.getPageSize());
                int pageSize  = pagedFliper.getPageSize();
                int pageNo = (pagedFliper.getPageNo()-1)*pageSize;
                Integer status = query.getStatus();
                if(status==null){
                    list = FacadeFactory.INSTANCE.getLyChatBo().findChatWarning(pageNo, pageSize);
                }else{
                    list = FacadeFactory.INSTANCE.getLyChatBo().findChatWarningByStatus(status,pageNo,pageSize);
                }
            }
            Sheet<LyChatWarningDTO> sheet = new Sheet<LyChatWarningDTO>(count, list);
            this.mergePagedDataModel(sheet, pagedFliper);
            return "";
        }catch(Exception e){
            logger.error("操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";
    }

	public String punish(){
        this.authenticateRun();
        try{
    		this.authenticateRun();
            Long seqid = findParamLong("lychatwarning_punish_seqid");
            String action = findParameter("lychatwarning_action");
            String description = findParameter("lychatoperationlog_description");

            if(seqid==null||action==null){
                mergeJsmessage("操作失败，参数异常！");
                return "";
            }

            LyChatWarningVO cw = baseSo.findById(LyChatWarningVO.class, seqid);
            if(cw==null){
                mergeJsmessage("操作失败，未找到该警告！");
                return "";
            }

            LyChatDetailVO lcd = FacadeFactory.INSTANCE.getBaseSo().findById(LyChatDetailVO.class, cw.getDetailId());
            if(lcd==null){
                mergeJsmessage("操作失败，未找到该聊天记录！");
                return "";
            }


            logger.info("LyChatWarningManagedBean punish " + seqid + "," + action + "," + description);
            Map logBean = BeanUtils.describe(cw);
            logger.info("LyChatWarningManagedBean punish START" + logBean);

            LyChatOperationVO qlco = new LyChatOperationVO();
            qlco.setOpId(action);
            if(baseSo.countObject(qlco)==0){
                mergeJsmessage("操作失败，未找到操作ID=" + action);
                return "";
            }

            String roleName = lcd.getRoleName();
            if(StringUtils.isNotEmpty(roleName)){
                roleName = URLEncoder.encode(roleName,"utf8");
            }

            StringBuilder urlSb = new StringBuilder();
            urlSb.append(xlniuxlychatsvr).append("/lychat/punish.do?")
                    .append("action=").append(action)
                    .append("&gameid=").append(lcd.getGameId())
                    .append("&serverid=").append(lcd.getServerId())
                    .append("&customerid=").append(lcd.getCustomerId() ==null?"":lcd.getCustomerId())
                    .append("&rolename=").append(roleName);
            logger.info("LyChatWarningManagedBean punish send:" + urlSb.toString());
            String resp = HttpClientUtil.get(urlSb.toString());

            int isSuccess;
            String errorMsg;
            if("0".equals(resp)){
                isSuccess=1;
                errorMsg="";
                //更新警告处理详情
                FacadeFactory.INSTANCE.getLyChatBo().lockLyChatWarning(seqid);
            }else {
                errorMsg = "操作失败: " + resp;
                logger.error("操作失败:" + "resp:" + resp + "," + logBean);
                mergeJsmessage(errorMsg);
                return "";
            }




                //save operation log
            LyChatOperationLogVO col = new LyChatOperationLogVO();
            col.setDetailId(cw.getDetailId());
            col.setOpId(action);
            col.setDescription(description);
            col.setOperator(this.currentUserLogo());
            col.setWorkTime(DateUtil.formatNowByDefault());
            col.setIsSuccess(isSuccess);
            col.setErrorMsg(errorMsg);
            logger.info("LyChatWarningManagedBean punish SUCCESS:"+logBean);
            baseSo.addObject(col);

            return "";
        }catch(Exception e){
            logger.error("操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";
	}
	public String ignore(){
        this.authenticateRun();
        try{
            Long seqid = Long.valueOf(findParameter("lychatwarning_ignore_seqid"));
            logger.info("LyChatWarningManagedBean ignore, seqId;"+seqid);
            LyChatWarningVO cw = baseSo.findById(LyChatWarningVO.class, seqid);

            if(null==cw){
                mergeJsmessage("操作失败，未找到该警告！");
                return "";
            }

            FacadeFactory.INSTANCE.getLyChatBo().ignoreLyChatWarning(seqid);
            logger.info("LyChatWarningManagedBean ignore SUCCESS;"+BeanUtils.describe(cw));
            //save operation log
//            LyChatOperationLogVO col = new LyChatOperationLogVO();
//            col.setDetailId(cw.getDetailId());
//            col.setDescription("");
//            col.setOperator(this.currentUserLogo());
//            col.setWorkTime(DateUtil.formatNowByDefault());
//            col.setIsSuccess(1);
//            baseSo.addObject(col);

            return "";
        }catch(Exception e){
            logger.error("操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";
	}
    public String ignoreAll(){
        this.authenticateRun();
        try{

            FacadeFactory.INSTANCE.getLyChatBo().ignoreAllLyChatWarning();

            return "";
        }catch(Exception e){
            logger.error("操作失败", e);
            mergeJsmessage("操作失败，原因：" + e.getMessage());
        }
        return "";
	}




}
