package com.xunlei.niux.manager.web.model.lychat;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.lychat.bo.BaseSo;
import com.xunlei.niux.data.lychat.facade.FacadeFactory;
import com.xunlei.niux.data.lychat.vo.LyChatSensitiveVO;
import com.xunlei.niux.manager.web.cache.LyChatCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;


public class LyChatSensitiveManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;
    private UploadedFile importupfile;
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");

    public LyChatSensitiveManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getLyChatSensitiveList(){
        this.authenticateRun();

        LyChatSensitiveVO query = findBean(LyChatSensitiveVO.class,"lychatsensitive");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<LyChatSensitiveVO> list = new ArrayList<LyChatSensitiveVO>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(query, page);
        }
        Sheet<LyChatSensitiveVO> sheet = new Sheet<LyChatSensitiveVO>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            String keyWord = findParameter("one_keyWord").trim();
            if(StringUtils.isEmpty(keyWord)){
                throw new XLRuntimeException("敏感词为空");
            }

            String curUer = this.currentUserLogo();
            if(!"linying".equals(curUer)){
                throw new XLRuntimeException("没有添加敏感词权限！");
            }

            LyChatCache.getInstance().updateSensitiveCache();
            Set<String> sensitiveSet = LyChatCache.getInstance().getSensitiveSet();
            if(sensitiveSet.contains(keyWord)){
                throw new XLRuntimeException(keyWord+"已经存在，请不要重复添加");
            }else{
                LyChatSensitiveVO cs = new LyChatSensitiveVO();
                cs.setKeyWord(keyWord);
                baseSo.addObject(cs);
                LyChatCache.getInstance().updateSensitiveCache();
                updateRemoteSensitive();
            }
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(LyChatSensitiveVO.class, id);
            }
            LyChatCache.getInstance().updateSensitiveCache();
            updateRemoteSensitive();
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }

    private void updateRemoteSensitive(){
        String url = "http://chat.niu.xunlei.com/r/chat/?gameid=0&serverid=0&customerid=0&roleid=0&rolename=0&rolelevel=0&chattime="+System.currentTimeMillis()+"&chatip=0&chatcontent=updateSensitiveWords&chatchannel=0";
        logger.info("update remote sensitive url:"+url);
        String resp = HttpClientUtil.get(url);
        logger.info("update remote sensitive response:"+resp);
    }

    public void importUploadFile(){
        String curUer = this.currentUserLogo();
        if(!"linying".equals(curUer)){
            throw new XLRuntimeException("没有添加敏感词权限！");
        }
        if(importupfile==null){
            return ;
        }
        try {
            String fname = importupfile.getName();
            String prefix=fname.substring(fname.lastIndexOf(".")+1);
            List<String> senList;
            if("txt".equals(prefix)){
                senList = importTxt();
            }else if("xlsx".equals(prefix) || "xls".equals(prefix)){
                senList = importXls();
            }else{
                alertJS("只能导入txt或者excel文件");
                return ;
            }

            for(String sen:senList){
                if(!LyChatCache.getInstance().getSensitiveSet().contains(sen)){
                    LyChatSensitiveVO lcs = new LyChatSensitiveVO();
                    lcs.setKeyWord(sen);
                    baseSo.addObject(lcs);
                }
            }

            LyChatCache.getInstance().updateSensitiveCache();

        } catch (Exception e) {
            e.printStackTrace();
            alertJS("导入异常："+e.getMessage());
            return;
        }

        return ;
    }

    private List<String> importTxt() throws Exception{
        BufferedReader reader = null;
        List<String> senList = new ArrayList<String>();
        try {
            String filename = FileUploadUtil.upLoadFile(importupfile);
            filename = FILEPATH + filename;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));
            String str;
            while ((str = reader.readLine()) != null) {
                if(StringUtils.isNotEmpty(str)){
                    senList.add(str.trim());
                }
            }
        }finally {
            if(reader!=null){
                reader.close();
            }
        }
        return senList;
    }
    private List<String> importXls() throws Exception{
        FileInputStream fis = null;
        List<String> senList = new ArrayList<String>();
        try {

            String filename= FileUploadUtil.upLoadFile(importupfile);
            filename = FILEPATH+filename;
            fis = new FileInputStream(new File(filename));
            Workbook wb = WorkbookFactory.create(fis);
            org.apache.poi.ss.usermodel.Sheet sheet = wb.getSheetAt(0);

            for(Row row: sheet){
                Cell cell0 = row.getCell(0);
                if(cell0!=null && StringUtils.isNotEmpty(cell0.toString())){
                    senList.add(cell0.toString().trim());
                }
            }
        }finally{
            if(fis != null){
                fis.close();
            }
        }
        return senList;
    }

    public UploadedFile getImportupfile() {
        return importupfile;
    }

    public void setImportupfile(UploadedFile importupfile) {
        this.importupfile = importupfile;
    }
}
