package com.xunlei.niux.manager.web.model.lychat;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.lychat.bo.BaseSo;
import com.xunlei.niux.data.lychat.dto.LyChatOperationLogDTO;
import com.xunlei.niux.data.lychat.facade.FacadeFactory;
import com.xunlei.niux.data.lychat.vo.LyChatOperationLogVO;
import com.xunlei.niux.data.lychat.vo.LyChatOperationVO;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.ExcelUtil;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.ss.usermodel.Workbook;


public class LyChatOperationLogManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public LyChatOperationLogManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }


    public String getLyChatOperationLogList(){
        this.authenticateRun();
        try{
            LyChatOperationLogVO query = findBean(LyChatOperationLogVO.class,"lychatoperationlog");
            PagedFliper pagedFliper = this.getFliper();
            int count = baseSo.countObject(query);
            pagedFliper.setRecordCount(count);
            List<LyChatOperationLogDTO> list = new ArrayList<LyChatOperationLogDTO>();
            if(count>0){
                rownum = 1;
                Page page=new Page();
                page.setPageNo(pagedFliper.getPageNo());
                page.setPageSize(pagedFliper.getPageSize());

                int pageSize  = pagedFliper.getPageSize();
                int pageNo = (pagedFliper.getPageNo()-1)*pageSize;

                list = FacadeFactory.INSTANCE.getLyChatBo().findLyChatOperationLog(query, pageNo, pageSize);
            }
            Sheet<LyChatOperationLogDTO> sheet = new Sheet<LyChatOperationLogDTO>(count, list);
            this.mergePagedDataModel(sheet, pagedFliper);
        }catch(Exception e){
        	e.printStackTrace();
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }
    
    /**
     * 将操作日志导出到excel中
     */
    public void export(){
    	logger.info("开始名单数据导出到excel文件");
		
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "聊天监控操作日志";	 
    	
 	    LyChatOperationLogVO query = findBean(LyChatOperationLogVO.class,"lychatoperationlog");
 	    
 	    List datas = new ArrayList();
 	    datas = FacadeFactory.INSTANCE.getLyChatBo().export(query);
 	    
 	    //生成数据到excel中
		String[] columnName = {"序号", "操作ID", "操作对象", "操作事件", "操作种类", "操作时长", "游戏", "区服", "账号", "角色", "成功", "操作备注", "操作人", "操作时间"};
		String filePath = "/tmp/lychatoperationlog.xls";
//		String filePath = "d:\\lychatoperationlog.xls";
		
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("聊天监控操作日志", title, columnName, filePath, datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"lychatoperationlog.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			logger.error("聊天监控操作日志导出异常", e);
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();	   
    }


}
