package com.xunlei.niux.manager.web.model.lottery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.manager.template.builder.jinzuan.LotteryDetailPageBuilder;
import com.xunlei.niux.manager.web.model.jinzuan.PrivilegeFailureUserManagedBean;
import com.xunlei.niux.manager.web.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.LotteryGiftBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 抽奖奖品业务处理类
 * @author lisu
 *  2013-04-19
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LOTTERYGIFT)
public class LotteryGiftManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LotteryGiftManagedBean.class.getName());
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("advicePhotoPath");
    private static final String REMOREFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remoteAdvicePicPath");
	private BaseSo baseSo;
	private LotteryGiftBo lotteryGiftBo;
	private static Map<String,Integer> lotteryMap = new HashMap<String,Integer>();
	private int rownum = 0;
	
	
	public LotteryGiftManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		lotteryGiftBo = FacadeFactory.INSTANCE.getLotteryGiftBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		init();
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	private void init(){
		  List datas = LibClassM.getLibClassDList("lotterytype");
          for(int i = 0; i < datas.size(); i++){
          	lotteryMap.put(((LibClassD)datas.get(i)).getItemname(), new Integer(1));
          }	                
	}
	

	
	public List<SelectItem> getGiftList(){
	    List<Gift> giftList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new Gift(), new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(giftList==null){
			return siList;
		}
		for(Gift product:giftList){
				if(lotteryMap.get(product.getGiftType()) != null)
				   siList.add(new SelectItem(product.getGiftId()+"", product.getGiftId()+"-"+product.getGiftName())); 	
		}
		return siList;
	}
	/**
	 * 修改产品信息
	 * @return
	 */
	public String editproductnum(){
		this.authenticateEdit();//编辑权限
		LotteryGift product=this.findBean(LotteryGift.class,"lotterygift");
		String one_productNum1 = this.findParameter("one_productNum1");
		String one_seqid1 = this.findParameter("one_seqid1");
		System.out.println("one_seqid1:"+one_seqid1);
		try{
			if(product==null){
				logger.info("奖品为空");
				throw new XLRuntimeException("奖品为空");
			}
			System.out.println("seqid:"+product.getSeqid());
			if(!StringTools.isEmpty(one_productNum1)){
				product.setLeftCount(Integer.parseInt(one_productNum1));
			}
			product.setEditBy(this.currentUserLogo());
			product.setEditTime(now());
			logger.info("用户["+product.getEditBy()+"]充值产品["+product.getGiftId()+"]数量["+product.getLeftCount()+"]");
			lotteryGiftBo.update_recharge(product);
		}catch(Exception e){
			logger.error("新增数量失败", e);
			alertJS("新增数量失败，原因：" + e.getMessage());
		}
		return "";
	}
	/**
	 * 查询抽奖奖品
	 * @return
	 */
	public String getQueryLotteryGiftList(){
		logger.info("开始抽奖奖品查询");
        String isValid = findParameter("isValid");
        this.authenticateRun();//验证运行权限
        LotteryGift activity = findBean(LotteryGift.class, "lotterygift");
        if(isValid != null){
            if(isValid.equals("")){
                activity.setIsValid(null);
            }else if(isValid.equals("true")){
                activity.setIsValid(true);
            }else if(isValid.equals("false")){
                activity.setIsValid(false);
            }
        }

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(activity);
        pagedFliper.setRecordCount(count);
        List<LotteryGift> list = new ArrayList<LotteryGift>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(activity, page);
        }
        Sheet<LotteryGift> sheet = new Sheet<LotteryGift>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增抽奖奖品
	 * @return
	 */
	public String add(){
		logger.info("开始抽奖奖品添加");		
		LotteryGift lotteryGift = this.findBean(LotteryGift.class,"lotterygift");
		try{
			if(lotteryGift==null){
				logger.info("抽奖奖品信息为空");
				throw new XLRuntimeException("抽奖奖品信息为空");
			}		
			Gift gift = new Gift();
			gift.setGiftId(Long.parseLong(lotteryGift.getGiftId()));
			gift = baseSo.findObject(gift);
			if(gift == null){
				logger.info("奖品信息为空");
				throw new XLRuntimeException("奖品信息为空");
			}

            String detailContent = lotteryGift.getDetailContent();
            if(StringUtils.isNotEmpty(detailContent)){
                lotteryGift.setDetailContent(detailContent.replace(FILEPATH, REMOREFILEPATH));
            }

            if(lotteryGift.getHasDetail()){
                lotteryGift = buildDetailPage(lotteryGift);
            }
            lotteryGift.setGiftName(gift.getGiftName());
            lotteryGift.setLeftCount(lotteryGift.getTotalCount());
            lotteryGift.setInputBy(this.currentUserLogo());
            lotteryGift.setInputTime(now());
			baseSo.addObject(lotteryGift);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改抽奖奖品
	 * @return
	 */
	public String edit(){
		logger.info("开始抽奖奖品信息修改");
		this.authenticateEdit();//编辑权限
		LotteryGift lotteryGift = this.findBean(LotteryGift.class,"lotterygift");
		try{
			if(lotteryGift==null){
				logger.info("抽奖奖品信息为空");
				throw new XLRuntimeException("抽奖奖品信息为空");
			}		
			Gift gift = new Gift();
			gift.setGiftId(Long.parseLong(lotteryGift.getGiftId()));
			gift = baseSo.findObject(gift);
			if(gift == null){
				logger.info("奖品信息为空");
				throw new XLRuntimeException("奖品信息为空");
			}
            String detailContent = lotteryGift.getDetailContent();
            if(StringUtils.isNotEmpty(detailContent)){
                lotteryGift.setDetailContent(detailContent.replace(FILEPATH, REMOREFILEPATH));
            }

            if(lotteryGift.getHasDetail()){
                lotteryGift = buildDetailPage(lotteryGift);
            }
            lotteryGift.setGiftName(gift.getGiftName());
            lotteryGift.setEditBy(this.currentUserLogo());
            lotteryGift.setEditTime(now());
			baseSo.updateObjectById(lotteryGift);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除抽奖奖品
	 * @return
	 */
	public String delete(){	
		logger.info("开始抽奖奖品信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(LotteryGift.class, id);		
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}

    private LotteryGift buildDetailPage(LotteryGift lotteryGift){
        String jumpUrl = "";
        if(StringUtils.isNotEmpty(lotteryGift.getDetailContent())){
            jumpUrl = new LotteryDetailPageBuilder().build(lotteryGift);
        }

        lotteryGift.setDetailUrl(jumpUrl);

        return lotteryGift;
    }
}
