package com.xunlei.niux.manager.web.model.lottery;

import java.util.ArrayList;
import java.util.List;

import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryActivity;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 抽奖活动业务处理类
 * @author lisu
 *  2013-04-19
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LOTTERYACTIVITY)
public class LotteryActivityManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LotteryActivityManagedBean.class.getName());
	private BaseSo baseSo;
	private int rownum = 0;
	
	
	public LotteryActivityManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询抽奖活动
	 * @return
	 */
	public String getQueryLotteryActivityList(){
		logger.info("开始抽奖活动查询");
        this.authenticateRun();//验证运行权限
        LotteryActivity activity = findBean(LotteryActivity.class, "lotteryactivity");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(activity);
        pagedFliper.setRecordCount(count);
        List<LotteryActivity> list = new ArrayList<LotteryActivity>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(activity, page);
        }
        Sheet<LotteryActivity> sheet = new Sheet<LotteryActivity>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增抽奖活动
	 * @return
	 */
	public String add(){
		logger.info("开始抽奖活动添加");		
		LotteryActivity activity = this.findBean(LotteryActivity.class,"lotteryactivity");	
		try{
			if(activity==null){
				logger.info("抽奖活动信息为空");
				throw new XLRuntimeException("抽奖活动信息为空");
			}		
			activity.setInputBy(this.currentUserLogo());
			activity.setInputTime(now());
			baseSo.addObject(activity);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改抽奖活动
	 * @return
	 */
	public String edit(){
		logger.info("开始抽奖活动信息修改");
		this.authenticateEdit();//编辑权限
		LotteryActivity activity = this.findBean(LotteryActivity.class,"lotteryactivity");	
		try{
			if(activity==null){
				logger.info("抽奖活动信息为空");
				throw new XLRuntimeException("抽奖活动信息为空");
			}		
			activity.setEditBy(this.currentUserLogo());
			activity.setEditTime(now());
			baseSo.updateObjectById(activity);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除抽奖活动
	 * @return
	 */
	public String delete(){	
		logger.info("开始抽奖活动信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(LotteryActivity.class, id);		
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
