package com.xunlei.niux.manager.web.model.linkinfo;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.apache.log4j.Logger;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.LinkLocation;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;


@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LINKINFO)
public class LinkInfoServerManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LinkInfoServerManagedBean.class.getName());
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	/**
	 * 一次添加多个server的维护信息
	 * @return
	 */
    public String addmoreserverweihuinfo() {
        this.authenticateAdd();//添加权限
        Date now=new Date();
        try{
        	LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
        	long timestamp = System.currentTimeMillis();
        	
        	//添加执行模板
        	String templateSchemaMark = linkInfo.getLinklocid() + "_" + timestamp;
        	//to table templateSchema: ext2, ext1, shemaTime, ext3
        	String weiHuSchemaId = addTemplateSchema(templateSchemaMark, linkInfo.getGameid(), linkInfo.getExt2(), "1");//分区状态设置为维护
        	String kaiQuSchemaId = addTemplateSchema(templateSchemaMark, linkInfo.getGameid(), linkInfo.getExt3(), "2");//分区状态设置为开区
			
        	if(weiHuSchemaId.isEmpty() || kaiQuSchemaId.isEmpty()){
        		return "";
        	}
        	
			linkInfo.setExt4(weiHuSchemaId);
			linkInfo.setExt5(kaiQuSchemaId);
			
			 String fenQuNums=findParameter("fenQuNums");//分区用|分割
			 logger.info("fenQuNums:"+fenQuNums);
			 //设置用户信息
			 UserInfo user=this.currentUserInfo();
			 linkInfo.setInputby(user.getTrueName());
			 linkInfo.setInputtime(sdf.format(now));
			 //设置位置信息
			 LinkLocation loc=FacadeFactory.INSTANCE.getLinkLocationBo().find(linkInfo.getLinklocid());
			 linkInfo.setLinklocgroupid(loc.getLinktype());
			 
			 String[] fenQuNumArray=fenQuNums.split("\\|");
			 for(String fenQuNum:fenQuNumArray){
			 	if(fenQuNum==null||"".equals(fenQuNum)){
			 		continue;
			 	}
			 	linkInfo.setExt1(fenQuNum);
			 	FacadeFactory.INSTANCE.getLinkInfoBo().add(linkInfo);
			 }

        }catch(Exception e){
        	logger.error("LinkInfoServerManagedBean_addmoreserverweihuinfo exception：",e);
        	alertJS("添加失败，原因："+e.getMessage());
        }
        return "";
    }
    
    public String editserverweihuinfo(){
        this.authenticateEdit();
        LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
       
        //添加到模板中
        long timestamp = System.currentTimeMillis();
    	String templateSchemaMark = linkInfo.getLinklocid() + "_" + timestamp;
    	String weiHuSchemaId = addTemplateSchema(templateSchemaMark, linkInfo.getGameid(), linkInfo.getExt2(), "1");//分区状态设置为维护中
    	String kaiQuSchemaId = addTemplateSchema(templateSchemaMark, linkInfo.getGameid(), linkInfo.getExt3(), "2");//分区状态由位置中设置为开区

    	linkInfo.setExt4(weiHuSchemaId);
		linkInfo.setExt5(kaiQuSchemaId);
    	
    	//设置用户信息
    	UserInfo user=this.currentUserInfo();
    	linkInfo.setEditby(user.getTrueName());
    	linkInfo.setEdittime(sdf.format(new Date()));
    	//设置位置信息
    	LinkLocation loc=FacadeFactory.INSTANCE.getLinkLocationBo().find(linkInfo.getLinklocid());
    	linkInfo.setLinklocgroupid(loc.getLinktype());
    	
    	FacadeFactory.INSTANCE.getLinkInfoBo().update(linkInfo);
    	
    	return "";
    }
    
	private String addTemplateSchema(final String seqMark,final String gameId,final String schemaTime,final String direct){
		String nowStr=sdf.format(new Date());
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid("000030");
		ts.setSchematime(schemaTime);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(false);
		ts.setExt1(gameId);
		ts.setExt2(seqMark);
		ts.setExt3(direct);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
		
		return getTemplateSchemaId(seqMark, direct);
	}
	
	private String getTemplateSchemaId(final String templateSchemaMark, final String direct) {
		
		String result = "";
		
		TemplateSchema queryTs=new TemplateSchema();
		queryTs.setExt2(templateSchemaMark);
		queryTs.setExt3(direct);
		
		List<TemplateSchema> list=FacadeFactory.INSTANCE.getTemplateSchemaBo().find(queryTs);
		
		if(list==null || list.isEmpty()){
			alertJS("添加失败，原因：取模板数据为空");
		}else if(list.size() != 1){
			StringBuilder logMsg = new StringBuilder();
			for(TemplateSchema ts : list){
				logMsg.append(ts.getSchemaid()).append("\\|");
			}
			logger.info("fenQuWeiHuGongGao模板数据重复 : " + logMsg.toString());
			alertJS("添加失败，原因：模板数据异常");
		}else{
			result = list.get(0).getSchemaid().toString();
		}
		
		return result;
	}
	
}
