
package com.xunlei.niux.manager.web.model.league;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.NiuxCashLotGroup;
import com.xunlei.niux.data.league.vo.Promoter;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.PageUtil;

public class NiuxCashLotGroupManagedBean extends BaseManagedBean  {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	public Map<String,String> getPromoterMap(){
		List<Promoter> promoterList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new Promoter(), new Page());
		Map<String,String> resultMap=new HashMap<String,String>();
		for(int i=0;i<promoterList.size();i++){
			Promoter promoter=promoterList.get(i);
			resultMap.put(promoter.getPromoterAccount(), promoter.getPromoterName());
		}
		return resultMap;
	}
	public List<SelectItem> getNiuxCashLotGroupSIList(){
		NiuxCashLotGroup query=new NiuxCashLotGroup();
		List<NiuxCashLotGroup> list=FacadeFactory.INSTANCE.getBaseSo().findObjects( query, new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(int i=0;i<list.size();i++){
			NiuxCashLotGroup group=list.get(i);
			SelectItem si=new SelectItem();
			si.setLabel(group.getGroupName());
			si.setValue(group.getLotGroupId());
			siList.add(si);
		}
		return siList;
	}
	public Map<Object,Object> getNiuxCashLotGroupMap(){
		NiuxCashLotGroup query=new NiuxCashLotGroup();
		List<NiuxCashLotGroup> list=FacadeFactory.INSTANCE.getBaseSo().findObjects( query, new Page());
		Map<Object,Object> map=new HashMap<Object,Object>();
		for(int i=0;i<list.size();i++){
			NiuxCashLotGroup group=list.get(i);
			map.put(group.getLotGroupId(), group.getGroupName());
		}
		return map;
	}
	public String getQueryNiuxCashLotGroups(){
		this.authenticateRun();//添加权限
		NiuxCashLotGroup niuxCashLotGroup=this.findBean(NiuxCashLotGroup.class,"niuxCashLotGroup");
		String lotGroupId=this.findParameter("lotGroupId");
		if(lotGroupId!=null&&!"".equals(lotGroupId)){
			niuxCashLotGroup.setLotGroupId(Long.valueOf(lotGroupId));
		}
		if(niuxCashLotGroup.getLotGroupId()!=null&&niuxCashLotGroup.getLotGroupId()==0){
			niuxCashLotGroup.setLotGroupId(null);
		}
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(niuxCashLotGroup);
		List<NiuxCashLotGroup> list=new ArrayList<NiuxCashLotGroup>();
		PagedFliper filper=this.getFliper();
		if(count>0){
			Page page=PageUtil.formatPage(filper);
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(niuxCashLotGroup, page);
		}
		Sheet<NiuxCashLotGroup> sheet=new Sheet<NiuxCashLotGroup>(count,list);
		this.mergePagedDataModel(sheet, filper);
		return "";
	}
	public String edit(){
		this.authenticateEdit();//添加权限
		NiuxCashLotGroup niuxCashLotGroup=this.findBean(NiuxCashLotGroup.class,"niuxCashLotGroup");
		Date now =new Date();
		UserInfo user=this.currentUserInfo();
		niuxCashLotGroup.setEditBy(user.getTrueName());
		niuxCashLotGroup.setEditTime(sdf.format(now));
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(niuxCashLotGroup);
		}catch(Exception e){
			logger.error("编辑失败",e);
			this.mergeJsmessage("编辑失败，原因："+e.getMessage());
		}
		return "";
	}
	public String add(){
		this.authenticateAdd();//添加权限
		NiuxCashLotGroup niuxCashLotGroup=this.findBean(NiuxCashLotGroup.class,"niuxCashLotGroup");
		Date now =new Date();
		UserInfo user=this.currentUserInfo();
		niuxCashLotGroup.setInputBy(user.getTrueName());
		niuxCashLotGroup.setInputTime(sdf.format(now));
		try{
			FacadeFactory.INSTANCE.getBaseSo().addObject(niuxCashLotGroup);
		}catch(Exception e){
			logger.error("添加失败",e);
			this.mergeJsmessage("添加失败，原因："+e.getMessage());
		}
		return "";
	}
}

