package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.SigninHistory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 用户签到历史处理类
 * @author lisu
 * 2014-04-03
 */
public class SigninHistoryManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(SigninHistoryManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public SigninHistoryManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询用户签到历史
	 * @return
	 */
	public String getQuerySigninHistorylList(){		
	    logger.info("开始用户签到历史查询");
        this.authenticateRun();//验证运行权限
        SigninHistory query = findBean(SigninHistory.class, "jinzuan_signinhistory");
        PagedFliper pagedFliper = this.getFliper();    
        if(query != null){
        	if(query.getUserId() != null&&query.getUserId()==0){
        		query.setUserId(null);
        	}
        }
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<SigninHistory> list = new ArrayList<SigninHistory>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("signInTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<SigninHistory> sheet = new Sheet<SigninHistory>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
