package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.Level;
import com.xunlei.niux.data.jinzuan.vo.Privilege;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 特权信息处理类
 * @author lisu
 * 2014-04-03
 */
public class PrivilegeManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PrivilegeManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public PrivilegeManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询特权信息
	 * @return
	 */
	public String getQueryPrivilegeList(){		
	    logger.info("开始特权信息查询");
        this.authenticateRun();//验证运行权限
        Privilege query = findBean(Privilege.class, "jinzuan_privilege");
        PagedFliper pagedFliper = this.getFliper();    
        if(query != null){
        	String jinzuan_privilege_privilegeType = this.findParameter("jinzuan_privilege_privilegeType");
        	System.out.println("jinzuan_privilege_privilegeType:"+jinzuan_privilege_privilegeType);
        	if(jinzuan_privilege_privilegeType != null){
        		if("0".equals(jinzuan_privilege_privilegeType)){
        			query.setPrivilegeType(null);
        		}
        	}
        	String jinzuan_privilege_isAnnual = this.findParameter("jinzuan_privilege_isAnnual");
        	if(jinzuan_privilege_isAnnual != null){
        		if("-1".equals(jinzuan_privilege_isAnnual)){
        			query.setIsAnnual(null);
        		}else if("0".equals(jinzuan_privilege_isAnnual)){
        			query.setIsAnnual(0);
        		}else{
        			query.setIsAnnual(1);
        		}        		
        	}
        	String jinzuan_privilege_isvalid = this.findParameter("jinzuan_privilege_isvalid");
        	if(jinzuan_privilege_isvalid!=null){
        		if("-1".equals(jinzuan_privilege_isvalid)){
        			query.setIsvalid(null);
        		}else if("0".equals(jinzuan_privilege_isvalid)){
        			query.setIsvalid(false);
        		}else{
        			query.setIsvalid(true);
        		}        		
        	}
        	if(query.getLevelNum()!=null&&query.getLevelNum().intValue()==0){
        		query.setLevelNum(null);
        	}
        }
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<Privilege> list = new ArrayList<Privilege>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("privilegeType", OrderType.DESC);
        	page.addOrder("isAnnual", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<Privilege> sheet = new Sheet<Privilege>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增特权信息
	 * @return
	 */
	public String add(){
		logger.info("开始特权信息添加");
		this.authenticateAdd();//添加权限
		Privilege privilege = findBean(Privilege.class, "jinzuan_privilege");	
		try{
			if(privilege==null){
				logger.info("特权信息为空");
				throw new XLRuntimeException("特权信息为空");
			}					
			int type = privilege.getPrivilegeType().intValue();
			Privilege query = new Privilege();
			query.setPrivilegeType(type);
			Privilege myprivilege = baseSo.findObject(query);
			if(myprivilege != null){
				if(!myprivilege.getSimpleName().equals(privilege.getSimpleName())){
					throw new XLRuntimeException("特权缩写于之前的不一致");
				}
			}
			query.setLevelNum(privilege.getLevelNum());
			query.setIsAnnual(privilege.getIsAnnual());
			myprivilege = baseSo.findObject(query);
			if(myprivilege != null){				
				throw new XLRuntimeException("该特权类型在等级"+myprivilege.getLevelNum()+"，已存在"+(myprivilege.getIsAnnual()==0?"非年费":"年费")+"记录，请不要重复添加");
			}
			privilege.setInputBy(this.currentUserLogo());
			privilege.setInputTime(now());
			baseSo.addObject(privilege);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改特权信息
	 * @return
	 */
	public String edit(){
		logger.info("开始特权信息修改");
		this.authenticateEdit();//编辑权限
		Privilege privilege = findBean(Privilege.class, "jinzuan_privilege");		
		try{
			if(privilege==null){
				logger.info("特权信息为空");
				throw new XLRuntimeException("特权信息为空");
			}
			int type = privilege.getPrivilegeType().intValue();
			Privilege query = new Privilege();
			query.setPrivilegeType(type);
			Privilege myprivilege = baseSo.findObject(query);
			if(myprivilege != null){
				if(!myprivilege.getSimpleName().equals(privilege.getSimpleName())){
					throw new XLRuntimeException("特权缩写于之前的不一致");
				}
			}
			query.setLevelNum(privilege.getLevelNum());
			query.setIsAnnual(privilege.getIsAnnual());
			myprivilege = baseSo.findObject(query);		
			System.out.println("seqid1:"+myprivilege.getSeqId() );
			System.out.println("seqid2:"+privilege.getSeqId() );
			if(myprivilege.getSeqId().longValue() !=privilege.getSeqId().longValue()){
				if(myprivilege != null){				
					throw new XLRuntimeException("该特权类型在等级"+myprivilege.getLevelNum()+"，已存在"+(myprivilege.getIsAnnual()==0?"非年费":"年费")+"记录，请不要重复添加");
				}
			}
		
			privilege.setEditTime(now());
			privilege.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(privilege);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除特权信息
	 * @return
	 */
	public String delete(){
		logger.info("开始特权信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(Level.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
