package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.Level;
import com.xunlei.niux.data.jinzuan.vo.Price;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 金钻单价处理类
 * @author lisu
 * 2014-04-03
 */
public class PriceManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PriceManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public PriceManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询金钻单价
	 * @return
	 */
	public String getQueryPriceList(){		
	    logger.info("开始金钻单价查询");
        this.authenticateRun();//验证运行权限
        Price query = findBean(Price.class, "jinzuan_price");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<Price> list = new ArrayList<Price>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.addOrder("inputTime", OrderType.ESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<Price> sheet = new Sheet<Price>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增金钻单价
	 * @return
	 */
	public String add(){
		logger.info("开始金钻单价信息添加");
		this.authenticateAdd();//添加权限
        Price price = findBean(Price.class, "jinzuan_price");
		try{
			if(price==null){
				logger.info("金钻单价信息为空");
				throw new XLRuntimeException("金钻单价信息为空");
			}		
			Price query = new Price();
            query.setPriceNo(price.getPriceNo());
            Price mylevel = baseSo.findObject(query);
            if(mylevel != null){
            	logger.info("该金钻单价已经存在");
				throw new XLRuntimeException("该金钻单价已经存在");
            }
            if(price.getAmountFlag()){
                price.setAmounts(price.getAmounts().replaceAll("，", ",").replaceAll(";", ",").replaceAll("；", ","));
            }
            price.setInputTime(now());
            price.setInputBy(this.currentUserLogo());
			baseSo.addObject(price);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改金钻单价
	 * @return
	 */
	public String edit(){
		logger.info("开始金钻单价信息修改");
		this.authenticateEdit();//编辑权限
		Price price = findBean(Price.class, "jinzuan_price");
		try{
			if(price==null){
				logger.info("金钻单价信息为空");
				throw new XLRuntimeException("金钻单价信息为空");
			}
			Price query = new Price();
            query.setPriceNo(price.getPriceNo());
            Price myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != price.getSeqId()){
                	logger.info("该金钻单价已经存在");
    				throw new XLRuntimeException("该金钻单价已经存在");
            	}
            }
            if(price.getAmountFlag()){
                price.setAmounts(price.getAmounts().replaceAll("，", ",").replaceAll(";", ",").replaceAll("；", ","));
            }
            price.setEditTime(now());
            price.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(price);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除金钻单价信息
	 * @return
	 */
	public String delete(){
		logger.info("开始金钻单价信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(Level.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
