package com.xunlei.niux.manager.web.model.jinzuan;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.json.JSONObject;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.Level;
import com.xunlei.niux.data.jinzuan.vo.MemberDetail;
import com.xunlei.niux.data.jinzuan.vo.Present;
import com.xunlei.niux.data.jinzuan.vo.PrivateKey;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.SignMd5;


/**
 * 人工赠送金钻会员业务处理类
 * @author lisu
 * 2014-05-27
 */
public class PresentManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PresentManagedBean.class.getName());
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//文件上传路径
	private static final String BASEURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("presentUrl");
	private static final String DUOBAO_BASEURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("duobaoUrl");
	private static final String EBASEURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("experienceUrl");
    private static final String BIZNO = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("presentByHandBizNo");
    private static final String DUOBAO_BIZNO = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("duobaoBizNo");
    private static final String EBIZNO = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("experienceBizNo");
    private static final String ip = "127.0.0.1";
    private static final String ACTNO = "present";
    private static final String DUOBAO_ACTNO = "duobao";
	private BaseSo baseSo;
    private int rownum = 0;
	private UploadedFile upfile;
	private String text = "";	
	
	
	
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public UploadedFile getUpfile() {
		return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}
	
	
	private String getPrivateKey(String bizNo){
		PrivateKey query = new PrivateKey();
		query.setBizNo(bizNo);
		PrivateKey mykey = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(mykey==null)return "";
		return mykey.getPrivateKey();		
	}
	
	/**
	 * 文件上传
	 * @return
	 */
	public String uploadFile(){     
		String filename=null;
		FileInputStream fis = null;
		Workbook wb = null;
		org.apache.poi.ss.usermodel.Sheet sheet = null;
		Row row = null;
		System.out.println("uploadFile:"+upfile);
		System.out.println("uploadFile:"+upfile);
		System.out.println("uploadFile:"+upfile);
		if(upfile!=null){
			try {
				filename=FileUploadUtil.upLoadFile(upfile);
				filename = FILEPATH+filename;
                fis = new FileInputStream(new File(filename));
                wb = WorkbookFactory.create(fis);
                sheet = wb.getSheetAt(0);
            	row = sheet.getRow(0);// 得到标题的内容对象。
    			int colNum = row.getPhysicalNumberOfCells(); // 得到标题总列数
    			int rowNum = sheet.getLastRowNum(); // 得到总行数
    			for (int i = 0; i <= rowNum; i++) { // 正文内容应该从第二行开始,第一行为表头的标题
    				row = sheet.getRow(i);
    				int j = 0;
    				while (j < colNum) {    
    					text += ((long)(row.getCell(j).getNumericCellValue())+"\n");
    					System.out.println("text:"+text);
    					j++;
    				}
    			}         
			} catch (Exception e) {
				e.printStackTrace();
			}finally{
				try{
					if(fis != null){
						fis.close();
						fis = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
		return text;
	}
	
	
      	
	public PresentManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 *  赠送失败时用于补发
	 * @return
	 */
	public String repair(){
		logger.info("开始人工赠送金钻会员补发");
		this.authenticateRun();//验证运行权限
		try{
			   String delseqids = findParameter("delseqids");	
				String ids[] = delseqids.split(",");
				String key = getPrivateKey(BIZNO);
				String ekey = getPrivateKey(EBIZNO);
				String duobaoKey = getPrivateKey(DUOBAO_BIZNO);
				for(String id:ids){					
					Present p = FacadeFactory.INSTANCE.getBaseSo().findById(Present.class, id);
					if(p.getFlag())continue;
					String mykey = p.getMemberType().intValue()==1?key:(p.getMemberType().intValue()==3?duobaoKey:ekey);
					String message = doProcess(p.getMemberType().intValue(),p.getUserId(),p.getOrderid(),p.getAmount(),p.getTimeType(),mykey);
					System.out.println("message:"+message);
					if(message==null){//如果赠送成功
						p.setFlag(true);
						MemberDetail detailquery = new MemberDetail();
						detailquery.setOrderId(p.getOrderid());
						detailquery.setUserId(p.getUserId());
						MemberDetail detail = baseSo.findObject(detailquery);
						p.setStartTime(detail.getOrderStartDate());
						p.setEndTime(detail.getOrderEndDate());
						p.setMonths(detail.getDayNum().intValue()+0L);						
					}else{
						p.setExt1((p.getExt1()==null?"":p.getExt1())+";"+message);//赠送失败的原因
						p.setExt1(subMessage(p.getExt1()));
					}					
					FacadeFactory.INSTANCE.getBaseSo().updateObjectById(p);
				}				    		
		}catch(Exception e){
			logger.error("补发失败", e);
			mergeJsmessage("补发失败，原因：" + e.getMessage());
		}		
		return "";
	}
	
	
	private String subMessage(String message){
		if(!StringTools.isEmpty(message)){
			if(message.length()>255){
				return message.substring(0,254);
			}			
		}
		return message;
	}
	
	/**
	 * 查询人工赠送金钻会员
	 * @return
	 */
	public String getQueryPresentList(){		
	    logger.info("开始人工赠送金钻会员查询");
        this.authenticateRun();//验证运行权限
        Present query = findBean(Present.class, "jinzuan_present");
        String jinzuan_present_flag = findParameter("jinzuan_present_flag");
        if(query !=null){
        	if(jinzuan_present_flag != null){
        		if("-1".equals(jinzuan_present_flag)){
        			query.setFlag(null);
        		}else if("1".equals(jinzuan_present_flag)){
        			query.setFlag(true);
        		}else{
        			query.setFlag(false);
        		}
        	}
        	if(query.getAmount()!=null&&query.getAmount().longValue()==0){
        		query.setAmount(null);
        	}
        	if(query.getUserId()!=null&&query.getUserId().longValue()==0){
        		query.setUserId(null);
        	}
        	if(query.getMonths()!=null&&query.getMonths().longValue()==0){
        		query.setMonths(null);
        	}
        	if(query.getTimeType()!=null&&query.getTimeType().intValue()==-1){
        		query.setTimeType(null);
        	}
        }
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<Present> list = new ArrayList<Present>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("presentTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<Present> sheet = new Sheet<Present>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增人工赠送金钻会员
	 * @return
	 */
	public String add(){
		logger.info("开始赠送人工赠送金钻会员信息");
		this.authenticateAdd();//添加权限
		Present present = findBean(Present.class, "jinzuan_present");	
		String uids = findParameter("uids");		
		String ids[] = uids.split("\n");
		if(ids == null||ids.length==0)return "";
		try{
			if(present==null){
				logger.info("人工赠送金钻会员信息为空");
				throw new XLRuntimeException("人工赠送金钻会员信息为空");
			}	
			String key = "";
			if(present.getMemberType().intValue()==1){
				key = getPrivateKey(BIZNO);
			}else if(present.getMemberType().intValue()==3){
				key = getPrivateKey(DUOBAO_BIZNO);
			}else{
				key = getPrivateKey(EBIZNO);
			}						
			for(String id:ids){
				//判断是否迅雷账号
				System.out.println("present id:"+id);
				if(StringTools.isEmpty(id))return "";
				id = id.trim();
				presentUid(present,Long.parseLong(id),present.getTimeType().intValue(),key);
			}
		}catch(Exception e){
			logger.error("赠送失败", e);
			mergeJsmessage("赠送失败，原因：" + e.getMessage());
		}finally{
			text = "";
		}
		return "";
	}
	
	
	/**
	 * 保存赠送数据
	 * @param present
	 * @param uid
	 */
	private void presentUid(Present present,long uid,int timeType,String key){
		String orderid = getOrderId();
		present.setPresentOperater(this.currentUserLogo());
		present.setPresentTime(now());
		present.setUserId(uid);
		present.setFlag(false);
		present.setOrderid(orderid);				
		baseSo.addObject(present);
		String message = doProcess(present.getMemberType().intValue(),uid,orderid,present.getAmount(),timeType,key);
		present = baseSo.findObject(present);
		if(message==null){//如果赠送成功
			present.setFlag(true);
			MemberDetail query = new MemberDetail();
			query.setOrderId(orderid);
			query.setUserId(uid);
			MemberDetail detail = baseSo.findObject(query);
			present.setStartTime(detail.getOrderStartDate());
			present.setEndTime(detail.getOrderEndDate());
			present.setTimeType(timeType);
			present.setMonths(detail.getDayNum().intValue()+0L);
		}else{
			present.setExt1((present.getExt1()==null?"":present.getExt1())+";"+message);//赠送失败的原因
			present.setExt1(subMessage(present.getExt1()));
		}
		
		baseSo.updateObjectById(present);
	}
	
	
	private String doProcess(int memberType, long uid,String orderid,long numValue,int timeType,String key){
		if(memberType==1){
			return doPresent(uid,orderid,numValue,timeType,key);
		}else if(memberType==3){//夺宝金钻
			return doDuobao(uid,orderid,numValue,timeType,key);
		}else {
			return doExperience(uid,orderid,numValue,timeType,key);
		}
	}
	
	/**
	 * 赠送正式会员
	 * @param uid
	 * @param orderid
	 * @param numValue
	 * @param timeType
	 * @param key
	 * @return
	 */
	private String doPresent(long uid,String orderid,long numValue,int timeType,String key){
		long timestmap = System.currentTimeMillis()/1000;		
		String sign = SignMd5.tomd5(uid+orderid+timeType +numValue+BIZNO +timestmap+key);
		StringBuffer sb = new StringBuffer(BASEURL);
		sb.append("uid=").append(uid).append("&timeType=").append(timeType).append("&numValue=").append(numValue)
		.append("&bizNo=").append(BIZNO).append("&actno=").append(ACTNO).append("&timestamp=").append(timestmap)
		.append("&sign=").append(sign).append("&orderid=").append(orderid);
		logger.info("present uid="+uid+",orderid="+orderid+",url:"+sb);
		String responseText = HttpClientUtil.get(sb.toString());
		logger.info("present uid="+uid+",orderid="+orderid+",responseText:"+responseText);
		String message = null;
		try{
			JSONObject data = new JSONObject(responseText);
			int rtn = data.getInt("rtn");			
			if(rtn == 0)return null;
			else {
				message = data.getString("data");
			}
			logger.info("isPresent failure  uid="+uid+",orderid="+orderid+",numValue="+numValue+",timeType="+timeType);
		}catch(Exception e){
			message = e.getMessage();
		}

		return message;
	}
	
	/**
	 * 赠送体验会员
	 * @param uid
	 * @param orderid
	 * @param numValue
	 * @param timeType
	 * @param key
	 * @return
	 */
	private String doExperience(long uid,String orderid,long numValue,int timeType,String key){
		long timestmap = System.currentTimeMillis()/1000;		
		String sign = Md5Encrypt.md5(uid+orderid+ACTNO+numValue+EBIZNO+ip+timestmap+key);
		StringBuffer sb = new StringBuffer(EBASEURL);
		sb.append("uid=").append(uid).append("&numValue=").append(numValue)
		.append("&bizNo=").append(EBIZNO).append("&actno=").append(ACTNO).append("&timestamp=").append(timestmap)
		.append("&sign=").append(sign).append("&orderid=").append(orderid).append("&ip=").append(ip);
		logger.info("experience uid="+uid+",orderid="+orderid+",url:"+sb);
		String responseText = HttpClientUtil.get(sb.toString());
		logger.info("experience uid="+uid+",orderid="+orderid+",responseText:"+responseText);
		String message = null;
		try{
			JSONObject data = new JSONObject(responseText);
			int rtn = data.getInt("rtn");			
			if(rtn == 0)return null;
			else {
				message = data.getString("data");
			}
			logger.info("isexperience failure  uid="+uid+",orderid="+orderid+",numValue="+numValue+",timeType="+timeType);
		}catch(Exception e){
			message = e.getMessage();
		}

		return message;
	}
	
	/**
	 * 赠送夺宝会员
	 * @param uid
	 * @param orderid
	 * @param numValue
	 * @param timeType
	 * @param key
	 * @return
	 */
	private String doDuobao(long uid,String orderid,long numValue,int timeType,String key){
		long timestmap = System.currentTimeMillis()/1000;		
		String sign = SignMd5.tomd5(uid+orderid+timeType +numValue+DUOBAO_BIZNO +timestmap+key);
		StringBuffer sb = new StringBuffer(DUOBAO_BASEURL);
		sb.append("uid=").append(uid).append("&timeType=").append(timeType).append("&numValue=").append(numValue)
		.append("&bizNo=").append(DUOBAO_BIZNO).append("&actno=").append(DUOBAO_ACTNO).append("&timestamp=").append(timestmap)
		.append("&sign=").append(sign).append("&orderid=").append(orderid);
		logger.info("duobao uid="+uid+",orderid="+orderid+",url:"+sb);
		String responseText = HttpClientUtil.get(sb.toString());
		logger.info("duobao uid="+uid+",orderid="+orderid+",responseText:"+responseText);
		String message = null;
		try{
			JSONObject data = new JSONObject(responseText);
			int rtn = data.getInt("rtn");			
			if(rtn == 0)return null;
			else {
				message = data.getString("data");
			}
			logger.info("isPresent failure  uid="+uid+",orderid="+orderid+",numValue="+numValue+",timeType="+timeType);
		}catch(Exception e){
			message = e.getMessage();
		}

		return message;
	}
	
	
	/**
	 * 获得订单号
	 * @return
	 */
	private  String getOrderId(){
		return DateUtil.getOrderTime()+getRandomNum()+"byhand";
	}
	
	public static void main(String args[]){
		System.out.println(getRandomNum());
	}
	
	/**
	 * 取四位随机数
	 * @return
	 */
	private static int getRandomNum(){
		int random=(int)(Math.random()*10000);
		return random;
		
	}
	
	public String delete(){
		logger.info("开始金钻单价信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(Level.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
