package com.xunlei.niux.manager.web.model.jinzuan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 充值订单处理类
 * @author lisu
 * 2014-03-31
 */
public class PayOrderManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PayOrderManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static Map<Integer,String> orderStatusMap;
    private static Map<Integer,String> timeTypeMap;
    private static Map<String,String> chargeTypeMap;
    private static Map<Integer,String>orderTypeMap;
    private static Map<Boolean,String>noticeActivityMap;
    
	public PayOrderManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	public Map<Boolean,String> getNoticeActivityMap(){
		if(null == noticeActivityMap){
			noticeActivityMap = new HashMap<Boolean,String>();
			noticeActivityMap.put(new Boolean(false), "未通知");
			noticeActivityMap.put(new Boolean(true), "成功");
		}
		return noticeActivityMap;
	}
	
	public Map<Integer,String> getOrderStatusMap(){
		if(null == orderStatusMap){
			orderStatusMap = new HashMap<Integer,String>();
			orderStatusMap.put(new Integer(1), "未支付");
			orderStatusMap.put(new Integer(2), "未完成");
			orderStatusMap.put(new Integer(3), "完成");
		}
		return orderStatusMap;
	}
	
	public Map<Integer,String> getTimeTypeMap(){
		if(null == timeTypeMap){
			timeTypeMap = new HashMap<Integer,String>();
			timeTypeMap.put(new Integer(1), "日");
			timeTypeMap.put(new Integer(2), "月");
			timeTypeMap.put(new Integer(3), "年");
		}
		return timeTypeMap;
	}
	
	public Map<Integer,String> getOrderTypeMap(){
		if(null == orderTypeMap){
			orderTypeMap = new HashMap<Integer,String>();
			orderTypeMap.put(new Integer(1), "充值");
			orderTypeMap.put(new Integer(2), "赠送");
		}
		return orderTypeMap;
	}
	
	public Map<String,String> getChargeTypeMap(){
		if(null == chargeTypeMap){
			chargeTypeMap = new HashMap<String,String>();
			chargeTypeMap.put("A1", "雷点");
			chargeTypeMap.put("B", "支付宝");
			chargeTypeMap.put("E", "网银");
			chargeTypeMap.put("W3", "微信公众账号");
			chargeTypeMap.put("E5", "百度钱包");
			chargeTypeMap.put("CC", "激活码");
			chargeTypeMap.put("W2", "微信二维码");
			chargeTypeMap.put("ES", "支付宝二维码");
			chargeTypeMap.put("JD", "京东支付");
		}
		return chargeTypeMap;
	}
	
	/**
	 * 查询充值订单
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public String getQueryPayOrderList(){		
	    logger.info("开始充值订单查询");
        this.authenticateRun();//验证运行权限
        PayOrder query = findBean(PayOrder.class, "jinzuan_payorder");
        PagedFliper pagedFliper = this.getFliper();   
        

        List<PayOrder> list = new ArrayList<PayOrder>(); 
        List<PayOrder> sumMoney = new ArrayList<PayOrder>(); 
        int count = 0;
        String excepttest = "";
        if(query != null && query.getExcepttest() != null){
        	excepttest = query.getExcepttest();
        } 
		String sumMoneySql = "select sum(orderMoney) as orderMoney,sum(payMoney) as payMoney ,\'"+excepttest+"\' as excepttest,jinzuan_payorder.* from jinzuan_payorder ";
		String detailSql = "select *,\'"+excepttest+"\' as excepttest from jinzuan_payorder ";
		StringBuilder where = new StringBuilder(" where 1=1 ");
		if(query != null){
			Object [] args = getWhere(where, query);
			
			if (pagedFliper != null) {
				int pageSize = pagedFliper.getPageSize();
				int currentPageNo = pagedFliper.getPageNo();
				if (pageSize > 0 && currentPageNo > 0) {
					String countSql = "select count(1) from jinzuan_payorder ";
					countSql += where.toString();
					sumMoneySql += where.toString();
					count = baseSo.count(countSql, args);
					int start = pageSize * (currentPageNo - 1);
					where.append(" order by orderTime desc limit ").append(start)
							.append(",").append(pageSize);
			    }		
		    }			
			
			detailSql += where.toString();
			logger.info("getQueryPayOrderList:" + detailSql);
			list = baseSo.executeQuery(PayOrder.class, detailSql, Arrays.asList(args));
			sumMoney = baseSo.executeQuery(PayOrder.class, sumMoneySql, Arrays.asList(args));
			
		}

		double orderMoney = 0D;
        double payMoney = 0D;
        for(PayOrder po:sumMoney){
        	orderMoney += po.getOrderMoney();
        	payMoney += po.getPayMoney();
        }
        BigDecimal bg = new BigDecimal(orderMoney);
        double forderMoney = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
        BigDecimal pg = new BigDecimal(payMoney);
        double fpayMoney = pg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
        PayOrder sumpayorder = new PayOrder();
        sumpayorder.setOrderMoney(forderMoney);
        sumpayorder.setPayMoney(fpayMoney);
        
        Sheet<PayOrder> sheet = new Sheet<PayOrder>(count, list);     
        if(sheet.getRowcount() > 0){
            sheet.getDatas().add(sumpayorder);
        } 
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	private Object[] getWhere(StringBuilder where, PayOrder data){
		if(data == null){
			return new Object[]{};
		}
		
		List<String> params = new ArrayList<String>(); 
		if(data.getUserId() != null && data.getUserId() != 0L){
			where.append(" and  UserId=?");
			params.add(String.valueOf(data.getUserId()));
		}
		if(StringTools.isNotEmpty(data.getAcode())){
			where.append(" and  Acode=?");
			params.add(data.getAcode());
		}
		if(StringTools.isNotEmpty(data.getActNo())){
			where.append(" and  ActNo=?");
			params.add(data.getActNo());
		}
		if(StringTools.isNotEmpty(data.getAdvNo())){
			where.append(" and  AdvNo=?");
			params.add(data.getAdvNo());
		}
		if(StringTools.isNotEmpty(data.getBankNo())){
			where.append(" and  BankNo=?");
			params.add(data.getBankNo());
		}
		if(StringTools.isNotEmpty(data.getBizNo())){
			where.append(" and BizNo=?");
			params.add(data.getBizNo());
		}
		if(StringTools.isNotEmpty(data.getChargeType())){
			where.append(" and ChargeType=?");
			params.add(data.getChargeType());
		}
		if(StringTools.isNotEmpty(data.getExt1())){
			where.append(" and Ext1=?");
			params.add(data.getExt1());
		}
		if(StringTools.isNotEmpty(data.getFinishTime())){
			where.append(" and FinishTime=?");
			params.add(data.getFinishTime());
		}
		if(StringTools.isNotEmpty(data.getFromdaytime())){
			where.append(" and orderTime>=?");
			params.add(data.getFromdaytime());
		}
		if(StringTools.isNotEmpty(data.getTodaytime())){
			where.append(" and orderTime<?");
			params.add(data.getTodaytime());
		}
		if(StringTools.isNotEmpty(data.getFromfinishTime())){
			where.append(" and finishTime>=?");
			params.add(data.getFromfinishTime());
		}
		if(StringTools.isNotEmpty(data.getTofinishTime())){
			where.append(" and finishTime<?");
			params.add(data.getTofinishTime());
		}
		if(StringTools.isNotEmpty(data.getIp())){
			where.append(" and Ip=?");
			params.add(data.getIp());
		}
		if(StringTools.isNotEmpty(data.getOrderId())){
			where.append(" and OrderId=?");
			params.add(data.getOrderId());
		}
		if(StringTools.isNotEmpty(data.getOrderTime())){
			where.append(" and OrderTime=?");
			params.add(data.getOrderTime());
		}
		if(StringTools.isNotEmpty(data.getPayBizNo())){
			where.append(" and PayBizNo>=?");
			params.add(data.getPayBizNo());
		}
		if(StringTools.isNotEmpty(data.getUserName())){
			where.append(" and UserName=?");
			params.add(data.getUserName());
		}
		if(data.getMemberStatus() != null && data.getMemberStatus() != 0L){
			where.append(" and MemberStatus=?");
			params.add(String.valueOf(data.getMemberStatus()));
		}
		if(data.getNoticeActivity() != null){
			where.append(" and NoticeActivity=?");
			params.add(String.valueOf(data.getNoticeActivity()));
		}
		if(data.getNumValue() != null){
			where.append(" and NumValue=?");
			params.add(String.valueOf(data.getNumValue()));
		}
		if(data.getOrderMoney() != null){
			where.append(" and OrderMoney=?");
			params.add(String.valueOf(data.getOrderMoney()));
		}
		if(data.getOrderStatus() != null && data.getOrderStatus() != 0L){
			where.append(" and OrderStatus=?");
			params.add(String.valueOf(data.getOrderStatus()));
		}
		if(data.getOrderType() != null && data.getOrderType() != 0L){
			where.append(" and OrderType=?");
			params.add(String.valueOf(data.getOrderType()));
		}
		if(data.getTimeType() != null && data.getTimeType() != 0L){
			where.append(" and TimeType=?");
			params.add(String.valueOf(data.getTimeType()));
		}

		if("1".equals(data.getExcepttest())){
			where.append(" And UserId NOT IN (SELECT userid FROM jinzuan_membership_test)");
		}else if("2".equals(data.getExcepttest())){
			where.append(" And UserId IN (SELECT userid FROM jinzuan_membership_test)");
		}
		
		return params.toArray();
	}
	

}
