package com.xunlei.niux.manager.web.model.jinzuan;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.MemberShipTest;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.util.StringTools;


/**
 * 金钻用户处理类
 * @author lisu
 * 2014-04-03
 */
public class MemberShipManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(MemberShipManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public MemberShipManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 金钻用户信息导出
	 */
	public void export(){
		logger.info("开始金钻用户信息导出");
		MemberShip query = findBean(MemberShip.class, "jinzuan_membership"); 
        if(query != null){
        	if(query.getUserId() != null&&query.getUserId()==0){
        		query.setUserId(null);
        	}
        	if(query.getLevelNum()!=null&&query.getLevelNum().intValue()==0){
        		query.setLevelNum(null);
        	}
        	if(query.getMemberStatus()!=null&&query.getMemberStatus().intValue()==-1){
        		query.setMemberStatus(null);
        	}
        	if(query.getIsAnnualMember()!=null&&query.getIsAnnualMember().intValue()==-1){
        		query.setIsAnnualMember(null);
        	}
        	if(query.getIsPay()!=null&&query.getIsPay().intValue()==-1){
        		query.setIsPay(null);
        	}
        	if(query.getIsYearPay()!=null&&query.getIsYearPay().intValue()==-1){
        		query.setIsYearPay(null);
        	}
        	if(query.getExperienceStatus()!=null&&query.getExperienceStatus().intValue()==-1){
        		query.setExperienceStatus(null);
        	}
        	Page page=new Page();
        	page.addOrder("registerTime", OrderType.DESC);
        	List<MemberShip> mslist = baseSo.findObjects(query, page);
        	//获得系统当前时间
        	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    		String now = sdf.format(new Date()); 
        	FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
    		//更新标题
     	    String title = "金钻会员";	        	    
     	    List datas = new ArrayList();
     	    String[] columnName = null;
 	    	for(MemberShip cr:mslist){
 	 	    	List list = new ArrayList();
 	 	    	list.add(cr.getUserId());
 	 	    	list.add(cr.getGrowthValue());
 	 	    	list.add(cr.getLevelNum());
 	 	    	list.add(cr.getExperienceStatus().intValue()==1?"是":"否");
 	 	    	list.add(cr.getMemberStatus().intValue()==1?"会员":"非会员");
 	 	    	list.add(cr.getIsAnnualMember().intValue()==1?"年费":"非年费");
 	 	    	list.add(cr.getIsPay().intValue()==1?"是":"否");
 	 	    	list.add(cr.getRegisterTime());
 	 	    	list.add(cr.getLastFeeTime());
 	 	    	list.add(cr.getAnnualMemberExpireDate());
 	 	    	list.add(cr.getMemberExpireDate());
 	 	    	list.add(cr.getExperienceDate());
 	 	    	datas.add(list);
 	 	    }	    
     	 	    //生成数据到excel中
     		columnName = new String[]{"迅雷uid","金钻成长值", "等级", "体验会员状态", "会员状态", "年费状态", "是否付费","首次开通金钻时间","上次续费时间","年费会员过期时间","会员过期时间","体验会员过期时间"};
     	
     	    
    		String filePath = "/tmp/membership.xls";
    		long beginTime = System.currentTimeMillis();
    		Workbook wb = ExcelUtil.create("金钻会员",title,columnName,filePath,datas);
    		long endTime = System.currentTimeMillis();
    		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
        	
            //弹出下载窗口
    		response.setHeader("Content-disposition", "attachment;filename="+now+"_membership.xls"); 
    		response.setContentType("application/x-download");
    		OutputStream ouputStream = null;
    		try {
    			ouputStream = response.getOutputStream();
    			wb.write(ouputStream);  
    		} catch (IOException e) {
    			e.printStackTrace();
    		}finally{
    		   if(datas != null){
    			   datas.clear();
    			   datas = null;
    		   }
    		   if(mslist != null){
    			   mslist.clear();
    			   mslist = null;
    		   }
    		}
    		FacesContext.getCurrentInstance().responseComplete();	  
        }
     }
	
	
	/**
	 * 删除测试用户信息
	 * @return
	 */
	public String deleteTest(){
		logger.info("开始测试用户信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(MemberShipTest.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	
	
	public String getQueryMemberShipTest(){	
		 PagedFliper pagedFliper = this.getFliper();    
		 String one_userId = this.findParameter("one_userId");
		 MemberShipTest query = new MemberShipTest();
		 if(StringTools.isEmpty(one_userId)){
			 query.setUserId(null);
		 }else{
			 query.setUserId(Long.parseLong(one_userId));
		 }	
		 int count = baseSo.countObject(query);
	        pagedFliper.setRecordCount(count);
	        List<MemberShipTest> list = new ArrayList<MemberShipTest>();  
	        if (count > 0) {
	        	rownum = 1;
	        	Page page=new Page();
	        	page.setPageNo(pagedFliper.getPageNo());
	        	page.setPageSize(pagedFliper.getPageSize());
	        	page.addOrder("editTime", OrderType.DESC);
	            list = baseSo.findObjects(query, page);
	        } 
	        Sheet<MemberShipTest> sheet = new Sheet<MemberShipTest>(count, list);     
	        this.mergePagedDataModel(sheet, pagedFliper);
	        return "";
	}
	
	/**
	 * 查询金钻用户
	 * @return
	 */
	public String getQueryMemberShipList(){		
	    logger.info("开始金钻用户查询");
        this.authenticateRun();//验证运行权限
        MemberShip query = findBean(MemberShip.class, "jinzuan_membership");
        PagedFliper pagedFliper = this.getFliper();    
        if(query != null){
        	if(query.getUserId() != null&&query.getUserId()==0){
        		query.setUserId(null);
        	}
        	if(query.getLevelNum()!=null&&query.getLevelNum().intValue()==0){
        		query.setLevelNum(null);
        	}
        	if(query.getMemberStatus()!=null&&query.getMemberStatus().intValue()==-1){
        		query.setMemberStatus(null);
        	}
        	if(query.getIsAnnualMember()!=null&&query.getIsAnnualMember().intValue()==-1){
        		query.setIsAnnualMember(null);
        	}
          	if(query.getIsPay()!=null&&query.getIsPay().intValue()==-1){
        		query.setIsPay(null);
        	}
          	if(query.getIsYearPay()!=null&&query.getIsYearPay().intValue()==-1){
        		query.setIsYearPay(null);
        	}
        	if(query.getExperienceStatus()!=null&&query.getExperienceStatus().intValue()==-1){
        		query.setExperienceStatus(null);
        	}
        }
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<MemberShip> list = new ArrayList<MemberShip>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("registerTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<MemberShip> sheet = new Sheet<MemberShip>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	public List<MemberShip> getQueryMemberShipTestList(){		
	    logger.info("开始金钻测试用户查询");
        this.authenticateRun();//验证运行权限
        String one_userId = this.findParameter("one_userId");
        List<MemberShip> mslist = FacadeFactory.INSTANCE.getMemberShipBo().queryMemberShip(StringTools.isEmpty(one_userId)?0:Long.parseLong(one_userId));
        return mslist;
	}
	
	
	public String addTestUser(){
		try{
			String testUserid = this.findParameter("one_userId");
			if(StringTools.isEmpty(testUserid)){
				throw new XLRuntimeException("参数为空");
			}
			MemberShipTest test = new MemberShipTest();
			test.setUserId(Long.parseLong(testUserid));
			MemberShipTest mst = baseSo.findObject(test);
			if(mst != null){
				throw new XLRuntimeException("该uid已存在");
			}
			MemberShip query = new MemberShip();
			query.setUserId(Long.parseLong(testUserid));
			MemberShip ship = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
			if(ship == null){
				throw new XLRuntimeException("该uid非金钻会员");
			}
			baseSo.addObject(test);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
			return "";
		}
	
	
	public String edit(){
		logger.info("开始测试用户信息修改");
		this.authenticateEdit();//编辑权限
	    MemberShip ship = findBean(MemberShip.class, "jinzuan_membership");
		try{
			if(ship==null){
				logger.info("测试用户信息为空");
				throw new XLRuntimeException("测试用户信息为空");
			}
			long userId = ship.getUserId().longValue();
			MemberShipTest query = new MemberShipTest();
			query.setUserId(userId);
			MemberShipTest mst = baseSo.findObject(query);
			if(mst == null){
				throw new XLRuntimeException("该用户非测试用户");
			}
			mst.setEditTime(now());
			mst.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(ship);		
			baseSo.updateObjectById(mst);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
}
