package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.GrowHistory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 成长值流水处理类
 * @author lisu
 * 2014-03-31
 */
public class GrowHistoryManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(GrowHistoryManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
      	
	public GrowHistoryManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询成长值流水
	 * @return
	 */
	public String getQueryGrowHistorylList(){		
	    logger.info("开始成长值流水查询");
        this.authenticateRun();//验证运行权限
        GrowHistory query = findBean(GrowHistory.class, "jinzuan_growhistory");
        PagedFliper pagedFliper = this.getFliper();   
        if(query != null){
        	if(query.getUserId()==null||query.getUserId()==0){
        		query.setUserId(0L);
        	}
        	if(query.getGrowType()!=null&&query.getGrowType().intValue()==0){
        		query.setGrowType(null);
        	}
        }
        int count = baseSo.countObject(query);      
        pagedFliper.setRecordCount(count);
        List<GrowHistory> list = new ArrayList<GrowHistory>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("recordTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<GrowHistory> sheet = new Sheet<GrowHistory>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	

}
