package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeBat;
import com.xunlei.niux.data.jinzuan.vo.CodeCode;
import com.xunlei.niux.data.jinzuan.vo.CodeCustomerProduct;
import com.xunlei.niux.data.jinzuan.vo.CodeProduct;
import com.xunlei.niux.data.jinzuan.vo.CodeRule;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 激活码批次处理类
 * @author lisu
 * 2014-05-22
 */
public class CodeBatManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CodeBatManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();
      	
	public CodeBatManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询激活码批次
	 * @return
	 */
	public String getQueryCodeBatList(){		
	    logger.info("开始激活码批次查询");
        this.authenticateRun();//验证运行权限
        CodeBat query = findBean(CodeBat.class, "jinzuan_code_bat");
        if(query != null){       	
        	String one_checkStatus = findParameter("one_checkStatus");
        	if("-1".equals(one_checkStatus)){
        		query.setCheckStatus(null);
        	}
        	if(query.getAmount()!=null&&query.getAmount().longValue()==0){
        		query.setAmount(null);
        	}
            if(query.getBatId()!=null&&query.getBatId().longValue()==0){
            	query.setBatId(null);
            }

        }
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<CodeBat> list = new ArrayList<CodeBat>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<CodeBat> sheet = new Sheet<CodeBat>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	private CodeRule getCodeRule(int codeLen) throws Exception{
    	CodeRule query = new CodeRule();
    	query.setCashNoLength(codeLen);
    	List<CodeRule> crlist = baseSo.findObjects( query, page);
    	return crlist==null||crlist.size()==0? null:crlist.get(0);
    }
	
	/**
	 * 生成激活码
	 * @return
	 */
	public String add(){
		logger.info("开始激活码信息生成");
		this.authenticateEdit();//编辑权限
		CodeBat bat = findBean(CodeBat.class, "jinzuan_code_bat");	
		String expireDay = findParameter("one_expireDay");
		try{
			if(bat==null){
				logger.info("激活码批次信息为空");
				throw new XLRuntimeException("激活码批次信息为空");
			}			
			CodeBat querybat = new CodeBat();
			querybat.setBatId(bat.getBatId());
			CodeBat cb = FacadeFactory.INSTANCE.getBaseSo().findObject(querybat);
			if(cb != null){
				logger.info("该批次已存在，请不要重复添加");
				throw new XLRuntimeException("该批次已存在，请不要重复添加");
			}
			CodeRule rule = getCodeRule(bat.getCodeLength());
	    	if(rule == null){
	    		throw new XLRuntimeException("长度为:"+bat.getCodeLength()+"的激活码生成规则不存在");
	    	}    	
	    	CodeCustomerProduct ccp = baseSo.findById(CodeCustomerProduct.class, bat.getCustomerProductId());
	    	if(ccp == null){
	    		throw new XLRuntimeException("商户商品编号："+bat.getCustomerProductId()+"不存在");
	    	}
	    	CodeProduct queryproduct = new CodeProduct();
	    	queryproduct.setProductId(ccp.getProductId());
	    	
	    	List<CodeProduct> cplist = baseSo.findObjects(queryproduct, page);
	    	if(cplist == null||cplist.size()==0){
	    		throw new XLRuntimeException("商品编号："+ccp.getProductId()+"不存在");
	    	}    	
			bat.setCheckStatus(0);
			bat.setExpireDay(expireDay);
			bat.setInputBy(this.currentUserLogo());
			bat.setInputTime(now());
			String one_batExpireDay = findParameter("one_batExpireDay");
			if(!StringTools.isEmpty(one_batExpireDay)){
				bat.setBatExpireDay(one_batExpireDay);
			}
			FacadeFactory.INSTANCE.getBaseSo().addObject(bat);
		}catch(Exception e){
			logger.error("激活码生成失败", e);
			mergeJsmessage("激活码生成失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	private CodeBat check(String idsStatus) throws Exception{
		String params [] = idsStatus.split("_");
		String seqid = params[0];
		String checkFlag = params[1];
		if(StringTools.isEmpty(seqid)||StringTools.isEmpty(checkFlag)){
			throw new XLRuntimeException("请执行审核操作");
		}
		CodeBat cb = FacadeFactory.INSTANCE.getBaseSo().findById(CodeBat.class, seqid);
		if(cb == null){
			logger.info("该批次号不存在");
			throw new XLRuntimeException("该批次号不存在");
		}
		if(cb.getCheckStatus().intValue()!=0){
			logger.info("该批次号已经审核过了，请不要重复审核");
			throw new XLRuntimeException("该批次号已经审核过了，请不要重复审核");
		}
		return cb;
	}
	
	/**
	 * 审核
	 * @return
	 */
	public String doPass(){
		try{
			//如果审核通过
			String idsStatus = findParameter("idsStatus");
			if(StringTools.isEmpty(idsStatus)){
				throw new XLRuntimeException("该批次号不存在");
			}			
			CodeBat cb = check(idsStatus);
			if(!cb.getIsInterface())//如果是非接口生成，需要立刻生成激活码
			   FacadeFactory.INSTANCE.getCodeCodeBo().addBatCode(cb);
			cb.setCheckStatus(1);			
			cb.setCheckTime(now());
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(cb);
		}catch(Exception e){
			mergeJsmessage("审核失败，原因：" + e.getMessage());
		}	
		return "";
	}
	
	public String doFail(){
		try{
			//如果审核通过
			String idsStatus = findParameter("idsStatus2");
			CodeBat cb = check(idsStatus);
			String failReason = findParameter("reason");
			if(StringTools.isEmpty(failReason)){
				throw new XLRuntimeException("该批次号拒绝理由不能为空");
			}
			cb.setCheckStatus(2);				
			cb.setFailureReason(failReason);				
			cb.setCheckTime(now());
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(cb);
		}catch(Exception e){
			mergeJsmessage("审核失败，原因：" + e.getMessage());
		}	
		return "";
	}
	
	/**
	 * 冻结激活码
	 * @return
	 */
	public String edit(){
		logger.info("开始激活码信息修改");
		this.authenticateEdit();//编辑权限
		CodeCode customer = findBean(CodeCode.class, "jinzuan_code_code");	
		try{
			if(customer==null){
				logger.info("激活码信息为空");
				throw new XLRuntimeException("激活码信息为空");
			}			
			baseSo.updateObjectById(customer);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
}
