package com.xunlei.niux.manager.web.model.jinzuan;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.ChangeBaiJin;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.util.StringTools;


/**
 * 金钻转白金处理类
 * @author lisu
 * 2014-06-03
 */
public class ChangeBaiJinManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(ChangeBaiJinManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private UploadedFile upfile;
	private String text = "";	
	
	
	
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public UploadedFile getUpfile() {
		return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}
    
    
	public ChangeBaiJinManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询金钻转白金记录
	 * @return
	 */
	public String getQueryChangeBaiJinList(){		
	    logger.info("开始金钻转白金记录查询");
        this.authenticateRun();//验证运行权限
        String change_baijin_userId = findParameter("change_baijin_userId");
        String change_baijin_operateStatus = findParameter("change_baijin_operateStatus");
        ChangeBaiJin query = new ChangeBaiJin();
        if(!StringTools.isEmpty(change_baijin_userId)){
        	query.setUserId(change_baijin_userId);
        }
        if(!StringTools.isEmpty(change_baijin_operateStatus)){
            int operatorStatus = Integer.parseInt(change_baijin_operateStatus);
            if(operatorStatus==1){
            	query.setOperateStatus(true);
            }else if(operatorStatus == 0){
            	query.setOperateStatus(false);
            }else{
            	query.setOperateStatus(null);
            }
        }
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<ChangeBaiJin> list = new ArrayList<ChangeBaiJin>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("operateTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<ChangeBaiJin> sheet = new Sheet<ChangeBaiJin>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	
	public String repair(){
		logger.info("开始金钻转白金确认");
		this.authenticateRun();//验证运行权限
		try{
			    String delseqids = findParameter("delseqids");	
			    System.out.println("delseqids:"+delseqids);
				String ids[] = delseqids.split(",");
				for(String id:ids){		
					if(StringTools.isEmpty(id))continue;
					id = id.trim();
					ChangeBaiJin baijin = baseSo.findById(ChangeBaiJin.class, id);
					if(baijin.getOperateStatus())continue;
				    try{
			 			FacadeFactory.INSTANCE.getMemberShipBo().delete(true,Long.parseLong(baijin.getUserId()));
			 			baijin.setOperateStatus(true);
			 		}catch(Exception e){
			 			if(StringTools.isEmpty(baijin.getFailReason())){
			 				baijin.setFailReason(e.getMessage());
			 			}else{
			 				baijin.setFailReason(baijin.getFailReason()+";"+e.getMessage());
			 			}			 			
			 			baijin.setOperateStatus(false);
			 		}	
					FacadeFactory.INSTANCE.getBaseSo().updateObjectById(baijin);
				}				    		
		}catch(Exception e){
			logger.error("确认失败", e);
			mergeJsmessage("确认失败，原因：" + e.getMessage());
		}		
		return "";
	}
	
	/**
	 * 新增金钻转白金记录
	 * @return
	 */
	public String add(){
		logger.info("开始新增金钻转白金记录");
		this.authenticateEdit();//编辑权限
		try{
			String uids = findParameter("orders");		
			System.out.println("uids:"+uids);
			System.out.println("uids:"+uids);
			System.out.println("uids:"+uids);
			String ids[] = uids.split("\n");
			if(ids == null||ids.length==0){
				logger.info("uid为空");
				throw new XLRuntimeException("uid为空");
			}	
			for(String uid:ids){
				if(StringTools.isEmpty(uid))continue;
				uid = uid.trim();
		        ChangeBaiJin baijin = new ChangeBaiJin();
		        baijin.setUserId(uid);
		        baijin.setMemberStatus(0);//默认是非会员
			    baijin.setOperateStatus(false);
				change(baijin,uid);
			    baijin.setOperateTime(now());
			    baijin.setOperator(this.currentUserLogo());
			    FacadeFactory.INSTANCE.getBaseSo().addObject(baijin);			   
			}                       			
		}catch(Exception e){
			logger.error("金钻转白金记录添加失败", e);
			mergeJsmessage("金钻转白金记录添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	

	
	private void change(ChangeBaiJin baijin,String uid) throws Exception {
		 MemberShip mquery = new MemberShip();
         Long userId = Long.parseLong(uid);
         mquery.setUserId(userId);
         MemberShip ship = baseSo.findObject(mquery);
         if(ship == null){        	
        	 return ;
         }
         baijin.setExpireTime(ship.getMemberExpireDate());
         String annualMemberExpireDate = ship.getAnnualMemberExpireDate();
         String memberExpireDate = ship.getMemberExpireDate();
         String nowDay = DateUtil.getNowDay();
         boolean isYear = false;
         boolean isMember = false;
         if(DateUtil.compareTime(annualMemberExpireDate, nowDay)>0){
        	 isYear = true ;
         }
         if(DateUtil.compareTime(memberExpireDate, nowDay)>0){
        	 isMember = true ;
         }
         if(isYear){
        	 baijin.setMemberStatus(2);
        	 baijin.setExpireTime(annualMemberExpireDate);
        	 baijin.setExpireDays(DateUtil.compareTime(annualMemberExpireDate, nowDay)/(60*60*24));
         }else {
        	 if(isMember){
        		 baijin.setMemberStatus(1);
        		 baijin.setExpireTime(memberExpireDate);
        		 baijin.setExpireDays(DateUtil.compareTime(memberExpireDate, nowDay)/(60*60*24));
        	 }else{//过期会员
        		 return ;
        	 }
         }
         try{
 			FacadeFactory.INSTANCE.getMemberShipBo().delete(false,Long.parseLong(uid));
 		    baijin.setOperateStatus(true);
 		}catch(Exception e){
 			baijin.setFailReason(e.getMessage());
 		}	
	}

}
