package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.data.giftcenter.vo.RankingListWebGift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;

import java.util.ArrayList;
import java.util.List;


public class RankingListWebGiftManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public RankingListWebGiftManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        RankingListWebGift query = findBean(RankingListWebGift.class,"rankinglistwebgift");
        if(query.getSeqid()==null||query.getSeqid()==0) {
            query = new RankingListWebGift();
        }
        PagedFliper pagedFliper = this.getFliper();

        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<RankingListWebGift> list = new ArrayList<RankingListWebGift>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("displayOrder", OrderType.ESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<RankingListWebGift> sheet = new Sheet<RankingListWebGift>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            RankingListWebGift req = findBean(RankingListWebGift.class,"rankinglistwebgift");
            if(req.getDisplayOrder()==null || req.getDisplayOrder()==0){
                throw new XLRuntimeException("排名为空");
            }
            if(req.getPackageId()==null || req.getPackageId()==0 || isNotOkPackageId(req.getPackageId())){
                throw new XLRuntimeException("找不到该礼包id:"+req.getPackageId());
            }

            baseSo.addObject(req);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败,原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            RankingListWebGift req = findBean(RankingListWebGift.class,"rankinglistwebgift");
            if(req.getDisplayOrder()==null || req.getDisplayOrder()==0){
                throw new XLRuntimeException("排名为空");
            }
            if(req.getPackageId()==null || req.getPackageId()==0 || isNotOkPackageId(req.getPackageId())){
                throw new XLRuntimeException("找不到该礼包id:"+req.getPackageId());
            }
            baseSo.updateObjectById(req);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(RankingListWebGift.class, id);
            }
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    private boolean isNotOkPackageId(Long packageId){
        return FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebgameGift.class,packageId)==null;
    }


}
