package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKey;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class PackageWebgameGiftKeyManagedBean extends BaseManagedBean {

    public PackageWebgameGiftKeyManagedBean() {
    }

    public String getQueryData(){
        this.authenticateRun();

        try {
            String packageIdStr = findParameter("query_packageId");
            String gameIdStr = findParameter("query_gameId");
            String platformIdStr = findParameter("query_platformId");
            Long gameId= null;
            Long platformId= null;
            if (StringUtils.isEmpty(packageIdStr)) {
                throw new XLRuntimeException("礼包ID必填");
            }
            Long packageId = Long.valueOf(packageIdStr);
            if (StringUtils.isNotEmpty(gameIdStr)) {
                gameId = Long.valueOf(gameIdStr);
            }
            if (StringUtils.isNotEmpty(platformIdStr)) {
                platformId = Long.valueOf(platformIdStr);
            }


            PagedFliper pagedFliper = this.getFliper();
            int count = FacadeFactory.INSTANCE.getGiftCenterBo().countPackageWebgameGiftKey(packageId,gameId,platformId);
            pagedFliper.setRecordCount(count);

            List<PackageWebgameGiftKey> list = new ArrayList<PackageWebgameGiftKey>();
            if(count>0){
                int pageNo = pagedFliper.getPageNo();
                int pageSize = pagedFliper.getPageSize();
                list = FacadeFactory.INSTANCE.getGiftCenterBo().getPackageWebgameGiftKey(packageId,gameId,platformId,(pageNo-1)*pageSize, pageSize);
            }
            Sheet<PackageWebgameGiftKey> sheet = new Sheet<PackageWebgameGiftKey>(count, list);
            this.mergePagedDataModel(sheet, pagedFliper);
        } catch (NumberFormatException e) {
            logger.error("数据异常", e);
            mergeJsmessage("数据异常，原因：" + e.getMessage());
        }
        return "";
    }


}
